% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr2t2d.R
\name{corr2t2d}
\alias{corr2t2d}
\title{Two-trace two-dimensional (2T2D) correlation spectroscopy}
\usage{
corr2t2d(Sam, Ref, Wave = NULL, preview = FALSE)
}
\arguments{
\item{Sam}{Numeric vector containing the sample spectrum to be correlated.
Can contain the spectral variable of the sample and reference spectrum
as \code{names}.}

\item{Ref}{Numeric vector containing the sample spectrum to be correlated.
Can contain the spectral variable of the sample and reference spectrum
as \code{names}.}

\item{Wave}{Numeric vector containing the spectral variable. Needs to be
specified if names of \code{Sam} and \code{Ref} are undefined.}

\item{preview}{Logical: Should a 3D preview of the asynchronous codistribution
spectrum be drawn at the end? Uses \code{\link[rgl]{persp3d}} from \pkg{rgl}
package.}
}
\value{
\code{corr2t2d} returns a list of class "corr2d" containing the
    complex correlation matrix (\code{$FT}), the correlation and
    disrelation coefficient as a complex matrix ($coef), the sample
    \code{$Ref1} and reference spectrum \code{$Ref2} as well as the 
    spectral variable \code{$Wave1} and \code{$Wave2}.
}
\description{
\code{corr2t2d} compares a pair of spectra in the form of a cross
     correlation analysis.
}
\details{
\code{corr2t2d} implements the Two-trace two-dimensional (2T2D) approach
    as described by I. Noda (2018) <DOI:10.1016/j.molstruc.2018.01.091>.
    The idea is to compare two spectra in a 2D correlation-like
    approach which was previously not possible as 2D correlation analysis
    usually needs at least three spectra.
}
\examples{
    testdata <- sim2ddata()
    
    twodtest <- corr2t2d(testdata[4, ], testdata[5, ])
    
    plot_corr2d(twodtest, Im(twodtest$FT))

}
\references{
I. Noda (2018) <DOI:10.1016/j.molstruc.2018.01.091>
}
\seealso{
For plotting of the resulting list containing the 2D correlation
    spectra or correlation coefficient see \code{\link{plot_corr2d}} and
    \code{\link{plot_corr2din3d}}.
}
