% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cosinor.lm.R
\name{ggplot_cosinor.lm}
\alias{ggplot_cosinor.lm}
\title{Plot a cosinor model}
\usage{
ggplot_cosinor.lm(object, x_str = NULL)
}
\arguments{
\item{object}{An object of class \code{cosinor.lm}}

\item{x_str}{Character vector naming the covariate(s) to be plotted. May be NULL to plot overall curve}
}
\description{
Given a cosinor.lm model fit, generate a plot of the data with the fitted values.
Optionally allows for plotting by covariate levels 0 and 1.
}
\examples{

fit <- cosinor.lm(Y ~ time(time) + X + amp.acro(X), data = vitamind)
ggplot_cosinor.lm(fit, "X")

}
