% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{init_bam_orthog}
\alias{init_bam_orthog}
\title{Initialize the parameters for an additive model}
\usage{
init_bam_orthog(y, X_lin, X_nonlin, B_all = NULL)
}
\arguments{
\item{y}{\code{n x 1} vector of data}

\item{X_lin}{\code{n x pL} matrix of predictors to be modelled as linear}

\item{X_nonlin}{\code{n x pNL} matrix of predictors to be modelled as nonlinear}

\item{B_all}{optional \code{pNL}-dimensional list of \code{n x L[j]} dimensional
basis matrices for each nonlinear term j=1,...,pNL; if NULL, compute internally}
}
\value{
a named list \code{params} containing
\enumerate{
\item \code{mu}: vector of conditional means (fitted values)
\item \code{sigma}: the conditional standard deviation
\item \code{coefficients}: a named list of parameters that determine \code{mu}
}
}
\description{
Initialize the parameters for an additive model, which may contain
both linear and nonlinear predictors. The nonlinear terms are modeled
using orthogonalized splines.
}
\note{
The parameters in \code{coefficients} are:
\itemize{
\item \code{beta_lin}: the \code{p x 1} linear coefficients, including the linear terms from \code{X_nonlin}
\item \code{f_j}: the \code{n x pNL} matrix of fitted values for each nonlinear function
\item \code{theta_j}: the \code{pNL}-dimensional of nonlinear basis coefficients
\item \code{sigma_beta}: \code{p x 1} vector of linear regression coefficient standard deviations
\item \code{sigma_theta_j}: \code{pNL x 1} vector of nonlinear coefficient standard deviations
}
}
\keyword{internal}
