% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_ts.R
\name{update_algorithm}
\alias{update_algorithm}
\title{Updating parameters in algorithm}
\usage{
update_algorithm(
  dist = c("Negative Binomial", "Poisson", "Linear TS", "ZIP", "ZINB"),
  Y_dist = 2,
  X_dist = 3,
  alpha_dist = 4,
  Bt = NULL,
  bt = NULL
)
}
\arguments{
\item{dist}{tuning parameter that controls which algorithm should be updated, with the options "Negative Binomial", "Poisson", "Linear TS", "ZIP", "ZINB"}

\item{Y_dist}{History of the observed stochastic outcome at the current decision time}

\item{X_dist}{History of the observed context at the current decision time}

\item{alpha_dist}{tuning parameter that controls the exploration-exploitation tradeoff. Default is 1.}

\item{Bt}{Outer product of contexts, only for \code{dist} = "Linear TS", default is NULL}

\item{bt}{Sum of contexts weighted by the outcome, only for \code{dist} = "Linear TS", default is NULL.}
}
\value{
The updated parameter estimates.
}
\description{
Updating parameters in algorithm
}
\examples{
update_algorithm(dist = "Negative Binomial")


}
