% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_number_max.R
\name{gen_number_max}
\alias{gen_number_max}
\title{Generate a New Number for Maximizing Mutual Information}
\usage{
gen_number_max(x)
}
\arguments{
\item{x}{A contingency table (numeric matrix or table).}
}
\value{
A modified contingency table with maximized mutual information.
}
\description{
This function modifies a given contingency table by swapping values between two cells
to maximize the mutual information. The function randomly selects two cells from the table
and adjusts their values in a way that increases mutual information. The function then
returns the modified table with the highest mutual information.
}
\details{
This function performs the following steps:
\enumerate{
\item Randomly selects two rows and two columns from the table.
\item Checks if the selected cells have non-zero values.
\item Adjusts the values of the selected cells in two different modified tables, \code{table1} and \code{table2}.
\item Calculates the mutual information for both modified tables.
\item Returns the table with the higher mutual information.
}
}
\examples{
# Example usage with a contingency table:
pair_table <- table(c(1, 2, 2, 3), c(1, 1, 2, 2))
gen_number_max(pair_table)

}
