% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_target_corr.R
\name{get_target_corr}
\alias{get_target_corr}
\title{Generate Samples with Target Kendall's Tau Correlation Using a Copula Approach}
\usage{
get_target_corr(
  x1,
  x2,
  target_corr_kendall,
  copula_type = "gaussian",
  inv_cdf_type = "quantile_7",
  degree = 10
)
}
\arguments{
\item{x1}{A numeric vector. The first dataset used for generating inverse CDFs.}

\item{x2}{A numeric vector. The second dataset used for generating inverse CDFs.}

\item{target_corr_kendall}{A numeric value. The desired target Kendall's tau correlation
between the two generated variables.}

\item{copula_type}{A string. The type of copula to use, either "gaussian" or "t" (default is "gaussian").}

\item{inv_cdf_type}{A string. The type of inverse CDF method to use. Options include:
"quantile_1", "quantile_4", "quantile_7", "quantile_8", "linear",
"akima", "poly" (default is "quantile_7").}

\item{degree}{An integer. The degree of the polynomial interpolation (default is 10).}
}
\value{
A list containing two components: \code{x1} and \code{x2}, which are the modified
versions of the input datasets \code{x1} and \code{x2} with the desired target
Kendall's tau correlation.
}
\description{
This function generates two variables with a specified target Kendall's tau correlation
using copula-based methods. The user can specify the type of copula (Gaussian or t),
the type of inverse CDF method to apply to the variables, and the degree of the polynomial
interpolation if applicable.
}
\details{
This function works by:
\enumerate{
\item Generating two variables using the specified copula type (Gaussian or t) with the target
Kendall's tau correlation.
\item Applying the chosen inverse CDF transformation to the generated copula samples.
\item Returning the modified variables that have the target correlation.
}
}
\examples{
# Example usage:
x1 <- ChickWeight$weight
x2 <- ChickWeight$Time
cor(x1, x2, method = "kendall")  # Calculate original Kendall's tau correlation
res <- get_target_corr(x1, x2, target_corr_kendall = 0,
                       copula_type = "gaussian", inv_cdf_type = "poly")
cor(res$x1, res$x2, method = "kendall")  # Calculate modified Kendall's tau correlation

}
\seealso{
\code{\link{gaussian_copula_two_vars}}, \code{\link{t_copula_two_vars}},
\code{\link{genCDFInv_quantile}}, \code{\link{genCDFInv_linear}},
\code{\link{genCDFInv_akima}}, \code{\link{genCDFInv_poly}}
}
