% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_log_odds.R
\name{plot_log_odds}
\alias{plot_log_odds}
\title{Plot Log-Odds Before and After Transformation}
\usage{
plot_log_odds(
  matrices,
  new_matrices,
  names_matrices,
  log_odds_general = log_odds_dc
)
}
\arguments{
\item{matrices}{A list of matrices for which the log-odds are calculated before the transformation.}

\item{new_matrices}{A list of matrices for which the log-odds are calculated after the transformation.}

\item{names_matrices}{A vector of names corresponding to the matrices in \code{matrices} and \code{new_matrices}.}

\item{log_odds_general}{A function used to calculate the log-odds (default is \code{log_odds_dc}).}
}
\value{
A bar plot showing the log-odds before and after the transformation for each matrix and overall.
}
\description{
This function calculates the log-odds ratio before and after applying a transformation
to multiple matrices, and generates a bar plot comparing the log-odds values.
The log-odds are calculated using a specified function (default is \code{log_odds_dc}).
}
\examples{
# Example matrices and names
matrices <- list(matrix(c(1, 2, 3, 4), nrow = 2), matrix(c(2, 3, 4, 5), nrow = 2))
new_matrices <- list(matrix(c(5, 6, 7, 8), nrow = 2), matrix(c(4, 5, 6, 7), nrow = 2))
names_matrices <- c("Matrix1", "Matrix2")
plot_log_odds(matrices, new_matrices, names_matrices)

}
