% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_copula_two_vars.R
\name{t_copula_two_vars}
\alias{t_copula_two_vars}
\title{Generate t-Copula Samples for Two Variables}
\usage{
t_copula_two_vars(n, p)
}
\arguments{
\item{n}{Integer. The number of samples to generate.}

\item{p}{Numeric. The correlation coefficient (\eqn{\rho}) between the two variables.
Must be in the range \code{[-1, 1]}.}
}
\value{
A matrix of size \code{n x 2}, where each row represents a sample,
and each column corresponds to one of the two variables. The values
are uniformly distributed in \code{[0, 1]}.
}
\description{
This function generates samples from a t-copula with two variables,
given the specified correlation coefficient between the variables.
}
\details{
The function internally constructs a correlation matrix for two variables:
\deqn{\rho_matrix = \begin{bmatrix} 1 & p \\ p & 1 \end{bmatrix}}
It then calls \code{generate_t_copula_samples} to generate samples using
a t-distribution with 5 degrees of freedom.
}
\examples{
# Example usage:
samples <- t_copula_two_vars(n = 1000, p = 0.7)
head(samples)

}
\seealso{
\code{\link{generate_t_copula_samples}}
}
