% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descarga_datos_abiertos.R
\encoding{UTF-8}
\name{descarga_datos_abiertos}
\alias{descarga_datos_abiertos}
\title{Descarga de datos abiertos}
\usage{
descarga_datos_abiertos(
  dbdir = tempfile(fileext = ".duckdb"),
  sites.covid = get_sites_covid(),
  site.covid.dic = get_site_dic(),
  read_format = c("duckdb", "tibble"),
  drv = duckdb::duckdb(),
  pragma_memory_limit = Sys.getenv("pragma_memory_limit"),
  tblname = "covidmx",
  colClasses = get_col_class(),
  download_process = c("pins", "download.file"),
  unzip_command = Sys.getenv("unzip_command"),
  unzip_args = Sys.getenv("unzip_args"),
  unzip_args_dict = list(exdir = ".", overwrite = TRUE),
  check_unzip_install = TRUE,
  clear_zip = (download_process[1] != "pins"),
  clear_csv = TRUE,
  use_dict = TRUE,
  datos_abiertos_zip_paths = NULL,
  datos_abiertos_unzipped_path = NULL,
  datos_abiertos_tbl = NULL,
  diccionario_zip_path = NULL,
  diccionario_unzipped_path = NULL,
  diccionario = NULL,
  quiet = FALSE,
  cache_datos = NULL,
  use_cache_on_failure = TRUE,
  cache_diccionario = NULL,
  force_download = FALSE,
  show_warnings = TRUE,
  board_url_name = "datos_abiertos",
  board_url_name_dict = "diccionario_covid",
  download_file_args = list(method = "curl", destfile = tempfile(), quiet = quiet),
  download_file_args_dict = download_file_args,
  descarga_db_datos_abiertos_tbl_args = list(),
  descarga_db_diccionario_ssa_args = list(),
  ...
)
}
\arguments{
\item{dbdir}{(\strong{opcional}) Direccion donde guardar la base de datos con terminacion \code{.duckdb}.
Corresponde al argumento de \code{\link[duckdb:duckdb]{duckdb::dbConnect__duckdb_driver()}}}

\item{sites.covid}{(\strong{opcional})  Sitios web con el vinculo a los archivos \code{.zip} de l
os datos abiertos. Puedes cambiarlo por uno de los historicos, por ejemplo. La estructura es
\code{c("nombre" = "url", "nombre2" = "url2")}. La ultima verificacion del sitio web default fue
el 6 de septiembre del 2022.}

\item{site.covid.dic}{(\strong{opcional})  Sitio desde el cual descarga del diccionario de datos.
La ultima verificacion del sitio fue el 6 de septiembre 2022.}

\item{read_format}{(\strong{opcional}) \code{"duckdb"} o \code{"tibble"} establece el formato
de lectura de la base de datos. En la mayoria de los casos \code{"tibble"} va a
resultar en un error de memoria. La opcion de \code{"duckdb"} siempre es mas rapida por lo cual
es el default.}

\item{drv}{(\strong{opcional}) Un  driver para \code{dbConnect} (default \code{duckdb::duckdb()})}

\item{pragma_memory_limit}{(\strong{opcional}) Limite de memoria para el programa
(ver \href{https://duckdb.org/docs/sql/pragmas}{PRAGMAS}). Cambialo a que sea mas o menos la mitad
de tu RAM. La forma mas sencilla es como una variable ambiental con
\code{Sys.setenv('pragma_memory_limit' = '1GB')} por ejemplo para un limite de 1 gigabyte.}

\item{tblname}{(\strong{opcional})  Nombre de la tabla de \code{duckdb} donde guardar los datos por
default se llama \code{covidmx}. Solo es relevante si estas usando el mismo \code{dbdir} para otro
proyecto distinto.}

\item{colClasses}{(\strong{opcional}) Clases de la columna para leer en \code{duckdb::read_csv_duckdb()}.}

\item{download_process}{(\strong{opcional})  Metodo para descargar ya sea \code{pins} o \code{download.file}.
Se recomienda \code{pins} pues guarda en memoria la fecha de la ultima descarga y analiza
si ha pasado mas de un dia desde la descarga. En caso afirmativo verifica si el
archivo ha cambiado y si hubo cambios entonces lo descarga.}

\item{unzip_command}{(\strong{opcional}) Forma de extraer la base de datos de datos abiertos
si \code{unzip} falla.
La forma de llamarla es con \code{system2(unzip_command, args = c(unzip_args, file_download_data))}.}

\item{unzip_args}{(\strong{opcional}) Argumentos de extraccion de la base de datos de datos abiertos
si \code{unzip} falla.
La forma de llamarla es con \code{system2(unzip_command, args = c(unzip_args, file_download_data))}.}

\item{unzip_args_dict}{(\strong{opcional}) Lista de argumentos para usar \code{utils::unzip} en el
diccionario de datos.}

\item{check_unzip_install}{(\strong{opcional}) Bandera de verificacion para checar si tienes
lo necesario para unzippear los datos en el caso de que \code{unzip} no sirva.}

\item{clear_zip}{(\strong{opcional}) Si borrar los archivos \code{.zip} descargados para el diccionario
y los datos abiertos. No se recomienda si estas usando \code{pins}. Ve la nota para mas informacion.}

\item{clear_csv}{(\strong{opcional}) Si borrar los archivos \code{.csv} que se generan despues de abrir
el zip. El default es que si pues en general solo requieres el \code{duckdb}.}

\item{use_dict}{(\strong{opcional}) Si descargar el diccionario de \code{site.covid.dic}.}

\item{datos_abiertos_zip_paths}{(\strong{opcional})  Camino a los datos abiertos si ya los
descargaste en \code{zip}}

\item{datos_abiertos_unzipped_path}{(\strong{opcional})  Camino a los datos abiertos \code{csv} si ya
los descargaste y descomprimiste el archivo \code{zip} en un \code{csv}}

\item{datos_abiertos_tbl}{(\strong{opcional}) Camino a un archivo \code{.duckdb} con los datos formateados}

\item{diccionario_zip_path}{(\strong{opcional})  Camino al diccionario si ya losdescargaste en \code{zip}}

\item{diccionario_unzipped_path}{(\strong{opcional})  Camino al diccionario \code{csv} si ya
lo descargaste y descomprimiste el archivo \code{zip} en un \code{csv}}

\item{diccionario}{(\strong{opcional})  Lo que resulta de realizar una descarga del diccionario
usando \code{descarga_diccionario}}

\item{quiet}{(\strong{opcional}) Variable para no mostrar mensajes}

\item{cache_datos}{(\strong{opcional}) Direccion donde guardar los datos en memoria usando \code{pins}
para no tener que volver a descargarlos si nada ha cambiado}

\item{use_cache_on_failure}{(\strong{opcional}) Booleana. Establece que si no se pueden descargar
datos nuevos utilice los que tenga en memoria. Por default es \code{TRUE}.}

\item{cache_diccionario}{(\strong{opcional}) Direccion donde guardar el diccionario en memoria
usando \code{pins} para no tener que volver a descargarlo si nada ha cambiado}

\item{force_download}{(\strong{opcional}) Analiza si cambio el pin y descarga datos nuevos en caso
afirmativo aunque haya pasado menos de un dia.}

\item{show_warnings}{(\strong{opcional}) si arrojar \code{warnings}}

\item{board_url_name}{(\strong{opcional}) Establece el nombre del \code{pins::board_url} para
los datos abiertos (si ya usas pins para que no se empalme).
Por default se llama \code{datos_abiertos}}

\item{board_url_name_dict}{(\strong{opcional}) Establece el nombre del \code{pins::board_url} para los
datos abiertos. Por default se llama \code{diccionario_covid}}

\item{download_file_args}{(\strong{opcional}) Lista de argumentos adicionales para \code{download.file}
de los datos si se elige este metodo para descargar.}

\item{download_file_args_dict}{(\strong{opcional}) Lista de argumentos adicionales
para \code{download.file} del diccionario si se elige este metodo de descarga.}

\item{descarga_db_datos_abiertos_tbl_args}{(\strong{opcional}) Lista con argumentos adicionales
para el \code{pins::pin_download} de datos abiertos}

\item{descarga_db_diccionario_ssa_args}{(\strong{opcional}) Lista con argumentos adicionales para el
\code{pins::pin_download} de datos abiertos}

\item{...}{(\strong{opcional}) Parametros adicionales para \code{DBI::dbConnect}.}
}
\value{
Lista de valores:
\itemize{
\item dats        - Tabla conectada mediante \code{duckdb::dbConnect__duckdb_driver()}
(si \code{duckdb}) o tibble (si \code{tibble})
\item disconnect  - Funcion para cerrar la conexion a la base de datos.
\item dict        - Lista de \code{tibble}s con el diccionario de datos para cada variable
}
}
\description{
Funcion para la descarga de datos abiertos de
la Direccion General de Epidemiologia (DGE)
}
\details{
La funcion de descarga principal es \code{\link[=descarga_datos_abiertos]{descarga_datos_abiertos()}} llama las siguientes funciones
en orden:
\itemize{
\item \code{\link[=descarga_diccionario]{descarga_diccionario()}} Se encarga de descargar y formatear el diccionario de datos
\item \code{\link[=descarga_db]{descarga_db()}} Se encarga de descargar y formatear la base de datos
\item \code{\link[=pega_db_datos_abiertos_tbl_y_diccionario]{pega_db_datos_abiertos_tbl_y_diccionario()}} Pega ambos en el formato lista de \code{covidmx}
}

A su vez \code{\link[=descarga_diccionario]{descarga_diccionario()}} ejecuta las siguientes para obtener el diccionario de datos:
\itemize{
\item \code{\link[=descarga_db_diccionario_ssa]{descarga_db_diccionario_ssa()}} Descarga el diccionario de la DGE
\item \code{\link[=unzip_db_diccionario_ssa]{unzip_db_diccionario_ssa()}} Libera el archivo \code{zip} descargado
\item \code{\link[=parse_db_diccionario_ssa]{parse_db_diccionario_ssa()}} Genera una lista de tiblles con el diccionario por variable
}

Por otro lado,\code{\link[=descarga_db]{descarga_db()}} ejecuta las siguientes para obtener los datos abiertos:
\itemize{
\item \code{\link[=descarga_db_datos_abiertos_tbl]{descarga_db_datos_abiertos_tbl()}} Descarga las bases de datos de covid de la DGE
\item \code{\link[=unzip_db_datos_abiertos_tbl]{unzip_db_datos_abiertos_tbl()}} Libera el archivo \code{zip} descargado
\item \code{\link[=parse_db_datos_abiertos_tbl]{parse_db_datos_abiertos_tbl()}} Genera una base de datos en \code{duckdb} (o \code{tibble}) c
on la informacion
}

Si en algun momento se interrumpio la descarga o hubo problemas de conexion o detuviste
el proceso de generacion de la base de datos abiertos puedes llamar a las funciones
de \code{\link[=read_datos_abiertos]{read_datos_abiertos()}}.
}
\note{
No te recomiendo borrar el cache con \code{clear_zip} o editarlo por cualquier otro medio si
estas usando \code{pins} pues puede romperse la dependencia. Si accidentalmente lo borraste
usa \code{pins::board_cache_path()} para ir al \code{path} y borrar manualmente toda la carpeta.
}
\section{Memoria \code{RAM}}{


Si tienes RAM que te sobre puedes no crear una base de datos en \code{duckdb} sino leer directo
el archivo \code{csv}. Esto se logra con \code{read_format = tibble}. No lo recomiendo pues puedes
terminar con tu sesion de \code{R} si se te acaba la memoria.

\emph{Windows} Para abrir el archivo \code{.zip} quiza requieras tambien descargar e instalar
\href{https://www.7-zip.org/}{\verb{7Zip}} por default el sistema lo busca en
\verb{C:\\\\Program Files\\\\7-Zip\\\\7z.exe} pero si no esta ese directorio es necesario que
en \code{unzip_command} especifiques el camino donde se instalo \verb{7z.exe}.
}

\section{Uso de \code{pins}}{


Para almacenar los datos se utiliza un pequenio cambio sobre la libreria \code{pins}. Los datos
se descargan y se almacenan en cache junto con informacion sobre cuando fue la descarga. Si
no ha pasado un dia desde la ultima descarga no se descarga nada nuevo. Si los datos que
se tienen no han cambiado respecto a lo que esta en linea tampoco se vuelven a descargar aunque
haya pasado mas de un dia.

\strong{Si se te fue el Internet} No te preocupes, \code{pins} lee tu descarga mas reciente.

Para ver donde estan descargados tus datos usa \code{pins::board_cache_path()}. Para borrarlos usa
\code{pins::cache_prune()}.
}

\section{Metodos de \code{unzip}}{


Por default el programa intenta abrir la base de datos con \code{utils::unzip()}. Sin embargo
historicamente la base de datos ha estado codificada de tal forma que \code{utils::unzip()} no
pueda abrirla. Para ello se utilizaban diferentes comandos en particular el default que
hemos visto funcionaba son los comandos de terminal \code{unzip} (en Linux/OSX) y \verb{7zip} (en Windows).
En caso de ser requeridos el sistema te lo hara saber junto con las instrucciones de instalacion
}

\examples{
\donttest{
# Descarga de la base de datos junto con diccionario en duckdb y la guarda en
# un archivo temporal.
# Puede cambiarse el dlink por el adecuado o dejarse en blanco
# quita la opción de sites.covid t site.covid.dic para descargar los de la DGE. 
# Esto es solo un ejemplo.
file_duck <- tempfile(fileext = ".duckdb")

#Estos links deben omitirse en una corrida normal. Se incluyen por ahora como ejemplo
#pero las opciones site.covid.dic y sites.covid deben eliminarse de abajo.
dlink     <- "https://github.com/RodrigoZepeda/covidmx/raw/main/datos_abiertos_covid19.zip"
diclink   <- "https://github.com/RodrigoZepeda/covidmx/raw/main/diccionario_datos_covid19.zip"

#En el ejemplo de R por normas de CRAN tenemos que hacerlo así pero en tu
#computadora puedes solo usar descargar datos sin el if else
if (RCurl::url.exists(dlink) & RCurl::url.exists(diclink)){
  datos_covid <- descarga_datos_abiertos(
    dbdir = file_duck,
    sites.covid = dlink, 
    site.covid.dic = diclink,
    show_warnings = FALSE
  )
  # Luego haces algo con esos datos...

  # Cuando terminas cierras la sesion:
  datos_covid$disconnect()

  # Despues podras leerlos con read_datos_abiertos cuando quieras:
  datos_covid <- read_datos_abiertos(dbdir = file_duck, site.covid.dic = diclink)
  datos_covid$disconnect()

  # Si no pones `dbdir` nota que los datos se guardan en un archivo temporal que se elimina
  # al cerrar tu sesion
  datos_covid <- descarga_datos_abiertos(sites.covid = dlink, show_warnings = FALSE,
                      site.covid.dic = diclink)

} else {
  datos_covid <- datosabiertos
}

# Desconectamos
datos_covid$disconnect()
}
}
\references{
Secretaría de Salud (2022). Datos Abiertos de COVID-19
URL: \url{https://www.gob.mx/salud/documentos/datos-abiertos-152127}
}
\seealso{
\code{\link[=read_datos_abiertos]{read_datos_abiertos()}}  \code{\link[=descarga_datos_red_irag]{descarga_datos_red_irag()}}
\code{\link[=descarga_datos_variantes_GISAID]{descarga_datos_variantes_GISAID()}} \code{\link[=casos]{casos()}}
}
