% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descarga_datos_red_irag.R
\encoding{UTF-8}
\name{descarga_datos_red_irag}
\alias{descarga_datos_red_irag}
\title{Descarga la base de datos de ocupacion hospitalaria de la red IRAG}
\usage{
descarga_datos_red_irag(
  nivel = c("Estatal", "Unidad Médica"),
  cache = NULL,
  use_cache_on_failure = TRUE,
  quiet = TRUE,
  force_download = FALSE,
  show_warnings = TRUE,
  ...
)
}
\arguments{
\item{nivel}{(\strong{opcional}) Regresa la ocupacion \code{"Estatal"}(default) o por \code{"Unidad Medica"}}

\item{cache}{(\strong{opcional}) cache para \code{\link[pins:board_url]{pins::board_url()}}. Representa el directorio donde
se almacenaran los datos descargados en formato de \code{pins}.}

\item{use_cache_on_failure}{(\strong{opcional})  parametro para \code{\link[pins:board_url]{pins::board_url()}}. En caso de
\code{TRUE} (default) si no puede descargar nueva informacion utiliza la que ya tiene en memoria
aunque sea vieja.}

\item{quiet}{(\strong{opcional}) booleana para no imprimir mensajes en la consola.}

\item{force_download}{(\strong{opcional})  analiza si cambio el pin y descarga datos nuevos en
caso afirmativo.}

\item{show_warnings}{(\strong{opcional}) si arrojar \code{warnings} o callar}

\item{...}{parametros adicionales para \code{\link[pins:pin_download]{pins::pin_download()}}.}
}
\value{
\code{tibble} con los datos de ocupacion hospitalaria
\itemize{
\item \verb{Unidad médica} - En caso \code{nivel = "Unidad Medica"} la unidad a la que pertenecen los datos
\item \code{Institución}   - Institucion a la que pertenece la unidad medica
\item \code{Estado}        - Entidad federativa de la informacion o de la unidad
\item \code{CLUES}         - La Clave Unica de Establecimientos de Salud para la unidad (si \code{nivel = "Unidad Medica"})
\item \code{Fecha}         - La fecha a la cual corresponde dicha ocupacion
\item \code{Actualizacion} - La fecha de actualizacion ultima de los datos.
\item \verb{Hospitalizados (\%)}    - Porcentaje de ocupacion en camas de hospitalizacion.
\item \verb{Ventilación (\%)}       - Porcentaje de ocupacion en ventiladores.
\item \verb{UCI y Ventilación (\%)} - Porcentaje de ocupacion en unidades de cuidado intensivo con ventilacion.
}
}
\description{
\code{descarga_datos_red_irag} Lee los datos de ocupacion hospitalaria de la \verb{RED IRAG}
disponibles en \url{https://www.gits.igg.unam.mx/red-irag-dashboard/reviewHome#}
y analizados a traves de \href{https://github.com/RodrigoZepeda/CapacidadHospitalariaMX}{RodrigoZepeda/CapacidadHospitalariaMX}
}
\details{
Los datos de Red IRAG son descargados diariamente de manera automatica en Github:
\href{https://github.com/RodrigoZepeda/CapacidadHospitalariaMX}{RodrigoZepeda/CapacidadHospitalariaMX}
y esta funcion los lee de ahi. Puede que esten un poco rezagados respecto a la pagina de la
\verb{RED IRAG} (\url{https://www.gits.igg.unam.mx/red-irag-dashboard/reviewHome#})
pero el rezago nunca es mayor a un dia.
}
\examples{
\donttest{
# Descarga de datos estatales
url_global <- paste0(
  "https://media.githubusercontent.com/media/RodrigoZepeda/",
  "CapacidadHospitalariaMX/master/processed/"
)

if (RCurl::url.exists(paste0(url_global, "HospitalizacionesMX_estatal.csv"))) {
  ocupacion_hospitalaria <- descarga_datos_red_irag("Estatal", show_warnings = FALSE)
}

# También puedes hacer la descarga por unidad medica
# Descarga de datos por unidad medica
if (RCurl::url.exists(paste0(url_global, "HospitalizacionesMX_unidad_medica.csv"))) {
  ocupacion_unidad <- descarga_datos_red_irag("Unidad Medica", show_warnings = FALSE)
}
}

}
\references{
Secretaría de Salud (2022). Sistema de Información de la Red IRAG
URL: \url{https://www.gits.igg.unam.mx/red-irag-dashboard/reviewHome}

Zepeda-Tello, R. (2022). Descarga Automática de Datos de la Red IRAG
URL: \url{https://github.com/RodrigoZepeda/CapacidadHospitalariaMX}
}
\seealso{
\code{\link[=descarga_datos_variantes_GISAID]{descarga_datos_variantes_GISAID()}} \code{\link[=descarga_datos_abiertos]{descarga_datos_abiertos()}} \code{\link[=read_datos_abiertos]{read_datos_abiertos()}}
}
