% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srcref_df.R
\name{join_on_containing_srcrefs}
\alias{join_on_containing_srcrefs}
\title{Join srcref data.frames by intersection of srcref spans}
\usage{
join_on_containing_srcrefs(x, y, by = c(srcref = "srcref"))
}
\arguments{
\item{x}{A \code{data.frame}, as produced by \code{as.data.frame} applied to a
\code{list_of_srcref}, against which \code{y} should be joined.}

\item{y}{A \code{data.frame}, as produced by \code{as.data.frame} applied to a
\code{list_of_srcref}, joining data from srcrefs data which encompasses srcrefs
from \code{x}.}

\item{by}{A named \code{character} \code{vector} of column names to use for the merge.
The name should be the name of the column from the left \code{data.frame}
containing a \code{list_of_srcref} column, and the value should be the name of a
column from the right \code{data.frame} containing a \code{list_of_srcref} column.}
}
\value{
A \code{data.frame} of \code{x} joined on \code{y} by spanning \code{srcref}
}
\description{
References to source code are defined by the source code line and column span
of the relevant source code. This function takes data frames containing that
information to pair source code in one data frame to source code from
another. In this case, source code from the left hand data frame is paired if
it is entirely contained within a record of source code in the right hand
data frame.
}
