% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srcrefs.R
\name{pkg_srcrefs}
\alias{pkg_srcrefs}
\alias{pkg_srcrefs.environment}
\alias{pkg_srcrefs.character}
\alias{pkg_srcrefs.coverage}
\title{Extract all the srcref objects of objects within a package namespace}
\usage{
pkg_srcrefs(x)

\method{pkg_srcrefs}{environment}(x)

\method{pkg_srcrefs}{character}(x)

\method{pkg_srcrefs}{coverage}(x)
}
\arguments{
\item{x}{A \code{\link[covr]{package_coverage}} coverage object, from which
the name of the package used is extracted.}
}
\value{
A \code{list_of_srcref}
}
\description{
Extract all the srcref objects of objects within a package namespace
}
\examples{
pkg <- system.file("examplepkg", package = "covtracer")
install.packages(
  pkg,
  type = "source",
  repos = NULL,
  quiet = TRUE,
  INSTALL_opts = "--with-keep.source"
)
pkg_srcrefs("examplepkg")

}
\seealso{
as.data.frame.list_of_srcref

Other srcrefs: 
\code{\link{test_srcrefs}()},
\code{\link{trace_srcrefs}()}
}
\concept{srcrefs}
