test_that("test_trace_df produces a data.frame of test, trace and doc data", {
  expect_silent(ttdf <- test_trace_df(examplepkg_cov))
  expect_true(any(ttdf$is_exported))
  expect_true(any(!ttdf$is_exported))
  expect_true(any(duplicated(ttdf$test_name)))
  expect_true(any(duplicated(ttdf$file)))
  expect_true(any(gsub("\\.Rd$", "", ttdf$file) == ttdf$alias))
  expect_true(ttdf[ttdf$alias == "help", "namespace"] == "utils")
  expect_true(ttdf[ttdf$alias == "help", "is_reexported"])
  expect_true(ttdf[ttdf$alias == "reexport_example", "namespace"] == "utils")
  expect_true(ttdf[ttdf$alias == "reexport_example", "is_reexported"])
  expect_true(all(ttdf[ttdf$alias == "hypotenuse", "namespace"] == "examplepkg"))
  expect_true(!any(ttdf[ttdf$alias == "hypotenuse", "is_reexported"]))
})
