% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CowbellAnalyzer.R
\name{generateCowbell}
\alias{generateCowbell}
\title{Performs the segmented linear regression analysis generating the cowbell function.}
\usage{
generateCowbell(concept, table, iterations = 1000, learningRate = 0.01)
}
\arguments{
\item{concept}{The previously in function \code{\link{generateCowbellConcept}} specified concept.}

\item{table}{The table that at least contains the data for the dependent and the two independent variables specified in concept.}

\item{iterations}{The number of iteration that should be done with the gradient optimizer.}

\item{learningRate}{The step size that should be applied in the gradient optimizer.}
}
\value{
A list with the data, the model with and without breakpoint and the F-Statistics.
}
\description{
This function takes the cowbell definition that was created with \code{\link{generateCowbellConcept}} and performs
a regression analysis. Additionally it also moves the breaking point to the maximal values of the independent
variables to later on test for the significance of the breaking point. This function needs relatively long to
compute as it uses a gradient based optimizer for optimizing a non - linear model.
}
\examples{
# Run a simplified anaylsis with 10 iterations only (to save time.)
concept<-generateCowbellConcept(Fun ~ Fluency * Absorption, 1, 9, 1, 7, 1, 7)
data(allFun)
test<-generateCowbell(concept, allFun, 10)
}
\seealso{
\code{\link{generateCowbellConcept}}
}
