% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataCox.R
\name{dataCox}
\alias{dataCox}
\title{Cox Proportional Hazards Model Data Generation From Weibull Distribution}
\usage{
dataCox(n, lambda, rho, x, beta, cens.rate)
}
\arguments{
\item{n}{Number of observations to generate.}

\item{lambda}{lambda parameter for Weibull distribution.}

\item{rho}{rho parameter for Weibull distribution.}

\item{x}{A data.frame with an input data to generate the survival times for.}

\item{beta}{True model coefficients.}

\item{cens.rate}{Parameter for exponential distribution, which is
responsible for censoring.}
}
\value{
A \code{data.frame} containing columns:
\itemize{
\item \code{id} an integer.
\item \code{time} survival times.
\item \code{status} observation status (event occured (1) or not (0)).
\item \code{x} a \code{data.frame} with an input data to generate the survival times for.
}
}
\description{
Function \code{dataCox} generaters random survivaldata from Weibull
distribution (with parameters \code{lambda} and \code{rho} for given input
\code{x} data, model coefficients \code{beta} and censoring rate for censoring
that comes from exponential distribution with parameter \code{cens.rate}.
}
\details{
For each observation true survival time is generated and a censroing time. If censoring time is less then survival time, then the survival time
is returned and a status of observations is set to \code{0} which means the
observation had censored time. If the survival time is less than censoring
time, then for this observation the true survival time is returned and the
status of this observation is set to \code{1} which means that the event has
been noticed.
}
\examples{
\dontrun{
x <- matrix(sample(0:1, size = 20000, replace = TRUE), ncol = 2)
dataCox(10^4, lambda = 3, rho = 2, x,
beta = c(1,3), cens.rate = 5) -> dCox
}
}
\references{
\url{http://onlinelibrary.wiley.com/doi/10.1002/sim.2059/abstract}

\code{Generating survival times to simulate Cox proportional hazards models}, 2005 by Ralf Bender, Thomas Augustin, Maria Blettner.
}
