% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/btensor.R
\name{btensor}
\alias{btensor}
\title{btensor}
\usage{
btensor(x, df = NULL, iknots = NULL, bknots, order)
}
\arguments{
\item{x}{a list of variables to build B-spline transforms of.  The tensor
product of these B-splines will be returned.}

\item{df}{degrees of freedom.  A list of the degrees of freedom for each
marginal.}

\item{iknots}{a list of internal knots for each x.  If omitted, the default
is to place no internal knots for all x.  If specified, the list needs to
contain the internal knots for all x.  If \code{df} and \code{iknots} are
both given, the \code{df} will take precedence.}

\item{bknots}{a list of boundary knots for each x.  As with the iknots, if
omitted the default will be to use the range of each x.  If specified, the
use must specify the bknots for each x.}

\item{order}{a list of the order for each x; defaults to 4L for all x.}
}
\value{
A matrix with a class \code{cpr_bt}
}
\description{
Tensor products of B-splines.
}
\details{
The return form this function is the tensor product of the B-splines
transformations for the given variables.  Say we have variables X, Y, and Z
to build the tensor product of.  The columns of the returned matrix
correspond to the column products of the three B-splines:

x1y1z1 x2y1z1 x3y1z1 x4y1z1 x1y2z1 x2y2z1 ... x4y4z4

for three fourth order B-splines with no internal knots.  The columns of X
cycle the quickest, followed by Y, and then Z.  This would be the same result
as
\code{ model.matrix( ~ bsplines(X) : bsplines(Y) : bsplines(Z) + 0) }.

See \code{vignette(topic = "cnr", package = "cpr")} for more details.
}
\examples{
tp <- with(mtcars,
           btensor(x = list(d = disp, h = hp, m = mpg),
                   iknots = list(numeric(0), c(100, 150), numeric(0)))
           )
tp

}
\seealso{
\code{\link{bsplines}}, \code{vignette(topic = "cnr", package = "cpr")}
}
