% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expfns.R
\name{exp_icdf}
\alias{exp_icdf}
\title{Inverse CDF for the exponential distribution}
\usage{
exp_icdf(n, theta)
}
\arguments{
\item{n}{Number of output exponential values}

\item{theta}{Scale parameter \eqn{\theta}}
}
\value{
Output is a value or a vector of values
from the exponential distribution.
}
\description{
\code{exp_icdf} simulates values from the inverse CDF of the
exponential distribution.
}
\details{
This function uses the exponential distribution of the form
\deqn{f(t)=\theta exp(-\theta t)}
to get the inverse CDF
\deqn{F^(-1)(u)=(-log(1-u))/\theta} where \eqn{u}
is a uniform random variable. It can be
implemented directly and is also called by the function
\code{\link{exp_memsim}}.
}
\examples{
simdta <- exp_icdf(n = 10, theta = 0.05)

}
