% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refactor.R
\name{cps_refactor}
\alias{cps_refactor}
\title{combine factor levels across years}
\usage{
cps_refactor(data, move_levels = TRUE)
}
\arguments{
\item{data}{A dataset containing already-labelled CPS data}

\item{move_levels}{Whether to move the levels "OTHER", "DON'T KNOW", and
"REFUSED" to the end of each factor's level set}
}
\description{
The response sets in certain CPS questions change between years. This function
consolidates several of these response sets across years (and fixes typos
from the CPS documentation), specifically race, Hispanic status, duration of
residency, reason for not voting, and method of registration. Additionally,
this creates a new column \code{VRS_VOTEMETHOD_CON} which consolidates multiple
expressions of vote method across years (By Mail, Early, and Election Day)
into one variable.
}
\details{
While consolidating response sets across multiple surveys can be
fraught with peril, this function attempts to combine disparate levels for
race and other CPS variable across multiple years. Some of these are
relatively straightforward typos fixes ("NON-HIPSANIC" should clearly match
"NON-HISPANIC"), but others have differing degrees of subjectivity applied.
Take this function with a grain of salt, as it depends on some exact variable
names you may or may not be using, and recode variables as needed for your
own uses. To explore exactly how these variables were recoded, you can run
\code{table(data$RACE, cps_refactor(data)$RACE)} in the console, substituting
your column of interest in for \code{RACE}.
}
\examples{
cps_refactor(cps_label(cps_2016_10k))

}
