% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpt.R
\name{cpt}
\alias{cpt}
\title{Function to return colour palettes functions from 'cpt-city'}
\usage{
cpt(
  pal = "mpl_inferno",
  n = 100,
  colorRampPalette = FALSE,
  rev = FALSE,
  frgb = rep(1, 3)
)
}
\arguments{
\item{pal}{Palette of colors available or the number of the position}

\item{n}{integer; number of colors}

\item{colorRampPalette}{Logical; to be used in sf and mapview.}

\item{rev}{Logical; to internally revert order of rgb color vectors.}

\item{frgb}{Numeric; vector of 3 to change internal rgb composition.
The order is red, green, blue}
}
\value{
A colour palette function.
}
\description{
This function return a collor palette based on the name or position of the
palette.
}
\details{
The cpt-city web archive comes from:
http://seaviewsensing.com/pub/cpt-city/
}
\examples{
{
library(cptcity)
image(matrix(1:100), col = cpt(pal = "mpl_inferno"))
find_cpt("temperature")
image(matrix(1:100), col = cpt("idv_temperature"))
image(matrix(1:100), col = cpt("idv_temperature", rev = TRUE))
\dontrun{
# Do not run
library(ggplot2)
ggplot(faithfuld, aes(waiting, eruptions)) +
geom_raster(aes(fill = density))

 ggplot(faithfuld, aes(waiting, eruptions)) +
 geom_raster(aes(fill = density)) +
 scale_fill_gradientn(colours = cpt(n = 100))
}
}
}
