% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependence_tree.R
\name{summary.cranly_dependence_tree}
\alias{summary.cranly_dependence_tree}
\title{summary method for \code{\link{cranly_dependence_tree}} objects}
\usage{
\method{summary}{cranly_dependence_tree}(object, ...)
}
\arguments{
\item{object}{a \code{\link{cranly_dependence_tree}} object.}

\item{...}{currently not used.}
}
\value{
A list with components \code{n_generations}, \code{parents}, and \code{dependence_index}.
}
\description{
Hard dependence summaries for R packages from a \code{\link{cranly_dependence_tree}} object
}
\details{
The summary method for a \code{\link{cranly_dependence_tree}} object returns
the number of generations the R package(s) in the object inherit
from (\code{n_generations}), the immediate parents of the R package(s)
(\code{parents}), and a dependence index \code{dependence_index} defined as
\deqn{ -\frac{\sum_{i \in C_p; i \ne p} \frac{1}{N_i} g_i}{\sum_{i
\in C_p; i \ne p} \frac{1}{N_i}} }

where \eqn{C_p} is the dependence tree for the package(s) \eqn{p},
\eqn{N_i} is the total number of packages that depend, link or
import package \eqn{i}, and \eqn{g_i} is the generation that
package \eqn{i} appears in the dependence tree of package(s)
\eqn{p}. The generation takes values on the non-positive integers,
with the package(s) \eqn{p} being placed at generation \code{0}, the
packages that \eqn{p} links to, depends or imports at generation
\code{-1} and so on.

A dependence index of zero means that the \eqn{p} only has
immediate parents. The dependence index weights the dependencies
based on how popular these are, in the sense that the index is
not penalized if the package depends on popular packages. The
greatest the dependence index is the more baggage the package
carries, and the maintainers may want to remove any dependencies
that are not necessary.
}
\examples{
\donttest{
cran_db <- clean_CRAN_db()
package_network <- build_network(cran_db)

## Two light packages
dep_tree <- build_dependence_tree(package_network, package = "brglm")
summary(dep_tree)

dep_tree <- build_dependence_tree(package_network, package = "gnm")
summary(dep_tree)

## A somewhat heavier package (sorry)...
dep_tree <- build_dependence_tree(package_network, package = "cranly")
summary(dep_tree)

}

}
\seealso{
\code{\link[=build_dependence_tree.cranly_network]{build_dependence_tree.cranly_network()}} \code{\link[=compute_dependence_tree]{compute_dependence_tree()}}
}
