% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{homicides15_tbl_df}
\alias{homicides15_tbl_df}
\title{Homicides in Nine US Cities (2015)}
\format{
A tibble with 1,922 observations and 15 variables:
\describe{
  \item{uid}{Unique identifier for the record (integer).}
  \item{city_name}{Name of the city where the homicide occurred (character).}
  \item{offense_code}{Offense code for the homicide (character).}
  \item{offense_type}{Type of offense (character).}
  \item{date_single}{Date and time of the homicide (POSIXct).}
  \item{address}{Address where the homicide occurred (character).}
  \item{longitude}{Longitude of the location (numeric).}
  \item{latitude}{Latitude of the location (numeric).}
  \item{location_type}{Type of location (character).}
  \item{location_category}{Category of location (character).}
  \item{fips_state}{FIPS code for the state (integer).}
  \item{fips_county}{FIPS code for the county (character).}
  \item{tract}{Census tract identifier (character).}
  \item{block_group}{Census block group identifier (integer).}
  \item{block}{Census block identifier (integer).}
}
}
\source{
Crime Open Database, 2015.
}
\usage{
data(homicides15_tbl_df)
}
\description{
This dataset contains detailed records of homicides that occurred in nine large US cities during the year 2015.
The data includes geographic locations, offense codes, and additional metadata, making it valuable for
analyzing patterns and trends in urban crime.
}
\details{
The dataset name has been changed to 'homicides15_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
crimedatasets package and assists users in identifying its specific characteristics. The suffix 'tbl_df'
indicates that the dataset is stored as a tibble, offering better printing and subsetting capabilities in R.
The original content has not been modified in any way.

This dataset provides insights into homicides in urban areas, offering geographic and temporal information for each case.
}
