% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{sentencing_sf}
\alias{sentencing_sf}
\title{Florida State Prison Sentencing Counts by County, 1905-1910}
\format{
A simple features (sf) object with 47 observations and 9 variables:
\describe{
  \item{name}{Name of the county (character).}
  \item{wpop}{White population (numeric).}
  \item{bpop}{Black population (numeric).}
  \item{sents}{Number of sentences in the county (numeric).}
  \item{plantation_belt}{Indicator of plantation belt counties (numeric).}
  \item{pct_ag_1910}{Percentage of agricultural land in 1910 (numeric).}
  \item{expected_sents}{Expected number of sentences based on population (numeric).}
  \item{sir_raw}{Index of racial disparities in sentencing (numeric).}
  \item{geometry}{Geometry column containing the spatial boundaries of the counties (list of simple features).}
}
}
\source{
Data compiled from historical census and sentencing records of Florida, 1905-1910.
}
\usage{
data(sentencing_sf)
}
\description{
This dataset contains information about state prison sentencing counts by county in Florida for the years 1905-1910.
The data includes various aggregated statistics such as the population of white and Black residents, the number of sentences,
and other demographic and agricultural factors at the county level. The dataset also includes geographic information
in the form of simple features (sf) representing county boundaries from the year 1910. The population data for each county
has been interpolated linearly between the decennial censuses of 1900 and 1910.
}
\details{
The dataset name has been changed to 'sentencing_sf' to avoid confusion with other datasets in the R ecosystem.
This naming convention helps distinguish this dataset as part of the crimedatasets package and assists users in identifying
its specific characteristics. The suffix 'sf' indicates that the dataset is a spatial object, using the Simple Features format.
The original content has not been modified in any way.
}
