% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{DualEndpointEmax-class}
\alias{DualEndpointEmax-class}
\alias{.DualEndpointEmax}
\alias{DualEndpointEmax}
\alias{.DefaultDualEndpointEmax}
\title{\code{DualEndpointEmax}}
\usage{
DualEndpointEmax(E0, Emax, ED50, ref_dose_emax = 1, ...)

.DefaultDualEndpointEmax()
}
\arguments{
\item{E0}{(\code{numeric})\cr either a fixed number or the two uniform distribution
parameters.}

\item{Emax}{(\code{numeric})\cr either a fixed number or the two uniform distribution
parameters.}

\item{ED50}{(\code{numeric})\cr either a fixed number or the two uniform distribution
parameters.}

\item{ref_dose_emax}{(\code{number})\cr the reference dose \eqn{x*} (strictly
positive number). Note that this is different from the \code{ref_dose} in the
inherited \code{\link{DualEndpoint}} model).}

\item{...}{parameters passed to \code{\link[=DualEndpoint]{DualEndpoint()}}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{DualEndpointEmax}} is the class for the dual endpoint model with \code{Emax}
function for dose-biomarker relationship.
}
\details{
This class extends the \code{\link{DualEndpoint}} class so that the dose-biomarker
relationship \eqn{f(x)} is modelled by a parametric \code{Emax} function:
\deqn{f(x) = E0 + [(Emax - E0) * (x/x*)]/[ED50 + (x/x*)],}
where \eqn{x*} is a reference dose, \eqn{E0} and \eqn{Emax} are the minimum
and maximum levels for the biomarker, and \eqn{ED50} is the dose achieving
half of the maximum effect \eqn{0.5 * Emax}.
All parameters can currently be assigned uniform distributions or be fixed.
}
\section{Slots}{

\describe{
\item{\code{E0}}{(\code{numeric})\cr either a fixed number or the two uniform distribution
parameters.}

\item{\code{Emax}}{(\code{numeric})\cr either a fixed number or the two uniform
distribution parameters.}

\item{\code{ED50}}{(\code{numeric})\cr either a fixed number or the two uniform
distribution parameters.}

\item{\code{ref_dose_emax}}{(\code{positive_number})\cr the reference dose \eqn{x*} (note
that this is different from the \code{ref_dose} in the inherited \code{\link{DualEndpoint}}
model).}
}}

\note{
Typically, end users will not use the \code{.DefaultDualEndpointEmax()} function.
}
\examples{
my_model <- DualEndpointEmax(
  mean = c(0, 1),
  cov = matrix(c(1, 0, 0, 1), nrow = 2),
  sigma2W = c(a = 0.1, b = 0.1),
  rho = c(a = 1, b = 1),
  E0 = c(0, 100),
  Emax = c(0, 500),
  ED50 = c(10, 200),
  ref_dose_emax = 1000
)
}
\seealso{
\code{\link{DualEndpoint}}, \code{\link{DualEndpointRW}}, \code{\link{DualEndpointBeta}}.
}
