% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crlog_line.R
\name{crlog_line}
\alias{crlog_line}
\title{Title Linear Cross lagged analysis}
\usage{
crlog_line(xname, yname, data.x1, data.y1, data.xt, data.yt)
}
\arguments{
\item{xname}{If linear cross lagged analysis is used between x and y, 'xname' is the name of x}

\item{yname}{If linear cross lagged analysis is used between x and y, 'yname' is the name of y}

\item{data.x1}{A numeric variable.}

\item{data.y1}{A numeric variable. 'data.x1' and 'data.y1' comes from the first time point}

\item{data.xt}{A numeric variable.}

\item{data.yt}{A numeric variable. 'data.xt' and 'data.yt' comes from the another time point}
}
\value{
a datafrme containing 'Relation','beta','se','z','pvalue','x','y','rmr' and 'cfi'.
Relation: This is a string that represents the relationship between the variables.
beta: This is the estimated coefficient of the model.
p: This is the p-value of the model coefficient, used to test whether the coefficient is significantly different from 0.
x: This is the input xname, representing the name of the x variable.
y: This is the input yname, representing the name of the y variable.
rmr: This is one of the model fit measures, representing the root mean square residual of the model.
cfi: This is one of the model fit measures, representing the comparative fit index of the model.
}
\description{
Title Linear Cross lagged analysis
}
\examples{
data(test_data1)
data(test_data2)
result <- crlog_line(xname="ASI",yname = "PWRI",data.x1 = test_data1$ASI,
                     data.y1 = test_data1$PWRI,data.xt = test_data2$ASI,
                     data.yt = test_data2$PWRI)
}
