% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monoTestBonf.R
\name{monoTestBonf}
\alias{monoTestBonf}
\title{Monotonicity test}
\usage{
monoTestBonf(simultAlpha = 0.05, OP_UMLE, OP_SE)
}
\arguments{
\item{simultAlpha}{Numerical value for the simultaneous significance level.}

\item{OP_UMLE}{Vector with the unconstrained parameter estimates of an ordinal predictor's categories represented by dummy variables
in an unconstrained model for ordinal response (see \code{\link[VGAM:vglm]{vlgm}}).}

\item{OP_SE}{Vector with the standard error of the parameters of an ordinal predictor's categories represented by dummy variables
in an unconstrained model for ordinal response (see \code{\link[VGAM:vglm]{vlgm}}).}
}
\value{
\code{testRes}: String value with outcomes either "Reject H_0" or "Not Reject H_0".

\code{simultAlpha}: Numerical value with the simultaneous significance level.

\code{indivAlphaA}: Numerical value with the individual significance level for each confidence interval.

\code{simultPvalue}: Numerical value with the p-value associated to the simultaneous significance level.
}
\description{
Tests the null hypothesis of monotonicity over a set of parameters associated to an ordinal predictor, according to Espinosa and Hennig (2019) <DOI:10.1007/s11222-018-9842-2>.
}
\examples{
monoTestBonf(simultAlpha=0.05, OP_UMLE = c(-0.352177095,-0.403928770,
-0.290875028,-0.769834449), OP_SE = c(0.246638339,0.247723681,0.267577633,0.300951441))
}
\references{
Espinosa, J., and Hennig, C. "A constrained regression model for an ordinal response
with ordinal predictors." Statistics and Computing 29.5 (2019): 869-890.
https://doi.org/10.1007/s11222-018-9842-2.
}
\seealso{
\code{\link[crov:mdcp]{mdcp}},
\code{\link[crov:monoTestConfReg]{monoTestConfReg}},
\code{\link[crov:plotCMLE]{plotCMLE}},
\code{\link[VGAM:vglm]{vlgm}}.
}
