% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amberdata.R
\name{amberdata_spot_reference}
\alias{amberdata_spot_reference}
\title{amberdata_spot_reference}
\usage{
amberdata_spot_reference(
  api_key,
  exchange = NULL,
  pair = NULL,
  include_inactive = "False",
  include_original_reference = "False",
  timeout_seconds = 60
)
}
\arguments{
\item{api_key}{your Amberdata API key}

\item{exchange}{choose a specific exchange or multiple exchanges
(comma-separated) rather than all exchanges}

\item{pair}{choose a specific pair or multiple pairs (comma-separated) rather
than all pairs}

\item{include_inactive}{If 'True', endpoint returns all pairs, including
delisted ones. Default is 'False'.}

\item{include_original_reference}{If 'True', endpoint returns
originalReference. Default is 'False'.}

\item{timeout_seconds}{seconds until the query times out. Default is 60.}
}
\value{
returns a list of reference information for each of the pairs on
Amberdata.
}
\description{
amberdata_spot_reference
}
\examples{
\dontrun{
api_key <- "..."
reference <- amberdata_spot_reference(api_key)
btc_usd <- amberdata_spot_reference(api_key, pair = "btc_usd")}
}
