% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/okcoin.R
\name{okcoin_api_call}
\alias{okcoin_api_call}
\title{okcoin_api_call}
\usage{
okcoin_api_call(
  url,
  key,
  signature,
  formatted_time,
  passphrase,
  timeout_seconds = 60
)
}
\arguments{
\item{url}{the full URL for the API call}

\item{key}{your API key for Okcoin}

\item{signature}{your hashed and encoded signature for Okcoin API calls}

\item{formatted_time}{a string containing the currrent timestamp in ISO 8601
format}

\item{passphrase}{the passphrase which you created when generating your
Okcoin API key}

\item{timeout_seconds}{seconds until the query times out. Default is 60.}
}
\value{
returns a dataframe containing the results of your API call
}
\description{
okcoin_api_call
}
\examples{
\dontrun{
url <- "..."
key <- "..."
path <- "..."
secret <- "..."
formatted_time <- okcoin_time()
method <- "GET"
signature <- okcoin_signature(path, secret, formatted_time, method)
passphrase <- "..."
data <- okcoin_api_call()}
}
