% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crcal.R
\name{ftirplot}
\alias{ftirplot}
\title{Plots the Crystalline Area of a FTIR Spectrum of Starch}
\usage{
ftirplot(spectrum, gauss, lim = c(1190, 1160, 985, 950))
}
\arguments{
\item{spectrum}{matrix. The matrix of FTIR spectrum baseline-corrected by drawing a tangentline in the 800-1300 cm-1 region. The first row corresponds to wavelength; the second row corresponds to intensity.}

\item{gauss}{matrix. The matrix of Gauss curve (gaussian holocrystalline-peak).}

\item{lim}{vector. Regions of the FTIR spectrum comprising the fixing points of the Gauss curve.}
}
\description{
Produces a graph of the crystalline area of a FTIR spectrum of starch and the Gauss curve.
}
\examples{
# Convert data frame to matrix, select A-type starch
spectrum <- as.matrix(t(FTIR[, c('wavelength','A')]))
# List of crystallinity components
crs <- fitFTIRc(spectrum = spectrum, mu = 1180, sigma = 60, k = 1, lim = c(1190, 1160, 985, 955))
# Original matrix
original <- crs$original
# Gaussian curve fit
gauss <- crs$gauss
# Plots the crystalline area of a FTIR spectrum
ftirplot(spectrum=original, gauss=gauss, lim=c(1190, 1160, 985, 950))
}
\author{
Claudio Pozo Valenzuela [aut, cre] and Saddys Rodriguez-llamazares [aut]
}

