% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r6_DBTable_v9.R
\name{validator_field_contents_blank}
\alias{validator_field_contents_blank}
\title{Blank data contents validator}
\usage{
validator_field_contents_blank(data)
}
\arguments{
\item{data}{A data.frame or data.table containing the data to validate}
}
\value{
Always returns TRUE
}
\description{
A pass-through validator that accepts any data without validation.
This is useful as a placeholder when no specific data content validation is needed.
}
\examples{
# This validator always returns TRUE regardless of input
test_data <- data.frame(id = 1:3, name = c("A", "B", "C"), value = c(10, 20, 30))
validator_field_contents_blank(test_data)

# Works with any data structure
empty_data <- data.frame()
validator_field_contents_blank(empty_data)
}
