% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confirmVars.R
\name{confirmVars}
\alias{confirmVars}
\title{Biomarker Confirmation Function}
\usage{
confirmVars(
  data = NULL,
  standardization = FALSE,
  columnWise = TRUE,
  biomks = NULL,
  outcomeType = c("binary", "continuous", "time-to-event"),
  Y = NULL,
  time = NULL,
  event = NULL,
  outfile = "nameWithPath",
  timeUnits = "years"
)
}
\arguments{
\item{data}{A data matrix or data frame with samples in rows and features/traits (including outcome and biomarkers) in columns.}

\item{standardization}{Logical; indicates if standardization is needed before biomarker confirmation/validation. Default is FALSE.}

\item{columnWise}{Logical; indicates if column-wise or row-wise normalization is needed for standardization. Default is TRUE.}

\item{biomks}{A vector of biomarker names to confirm/validate. Subset of column names in the data parameter.}

\item{outcomeType}{The type of the outcome variable. It has three choices: "binary" (default), "continuous", and "time-to-event".}

\item{Y}{The outcome variable name when the outcome type is either "binary" or "continuous".}

\item{time}{The time variable name when the outcome type is "time-to-event".}

\item{event}{The event variable name when the outcome type is "time-to-event".}

\item{outfile}{A string representing the output file, including the path if necessary, but without the file type extension.}

\item{timeUnits}{A character vector specifying the units in which time is measured for the survival data. Default is "years".}
}
\value{
A list containing:
\item{fit}{A model with selected variables for the given outcome variable.}
\item{allplot}{A list of plots generated during the confirmation/validation process.}
There might be extra plots in the list for time-to-event outcome
}
\description{
This function confirms and validates known biomarkers in a given dataset.
}
\details{
Use this function to assess whether individual variables or groups of variables
have an impact on an outcome variable within a dataset. The outcome variable can be binary,
continuous, or time-to-event. Note that this function is not intended for model confirmation,
as it doesn't incorporate coefficients from previous research.
}
\examples{
# Load in data sets:
data("datlist", package = "csmpv")
tdat = datlist$training

# The confirmVars function saves files locally. You can define your own temporary directory. 
# If not, tempdir() can be used to get the system's temporary directory.
temp_dir = tempdir()

# As an example, let's define Xvars, which will be used later:
Xvars = c("highIPI","B.Symptoms", "MYC.IHC", "BCL2.IHC", "CD10.IHC", "BCL6.IHC")

# confirmVars can work with three different outcome types. 
# Here, we use binary as an example:
bconfirm = confirmVars(data = tdat, biomks = Xvars, Y = "DZsig",
                        outfile = paste0(temp_dir, "/confirmBinary"))
# You might save the files to the directory you want.

# To delete the temp_dir, use the following:
unlink(temp_dir)
}
\references{
Hastie, T. J. and Pregibon, D. (1992) Generalized linear models. Chapter 6 of Statistical Models in S eds J. M. Chambers and T. J. Hastie, Wadsworth & Brooks/Cole.
 
 Therneau, T., Grambsch, P., Modeling Survival Data: Extending the Cox Model. Springer-Verlag, 2000.
 
 Kassambara A, Kosinski M, Biecek P (2021). survminer: Drawing Survival Curves using 'ggplot2', R package version 0.4.9,
        <https://CRAN.R-project.org/package=survminer>.
}
\author{
Aixiang Jiang
}
