% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_utils.R
\name{irank_against}
\alias{irank_against}
\alias{frank_against}
\title{Compute integer ranks in another reference vector}
\usage{
irank_against(x, v, omega = 0, increasing = FALSE, na.rm = FALSE)

frank_against(x, v, omega = 0, increasing = FALSE, na.rm = FALSE)
}
\arguments{
\item{x}{numeric query vector.}

\item{v}{numeric reference vector.}

\item{omega}{numeric value in [0,1], defining how ties in \code{x} (if any) are handled; default is \code{0}. See Details.}

\item{increasing}{logical; if \code{FALSE} (default), then large elements in \code{x} receive a small rank. Otherwise, large elements in \code{x} receive a large rank.}

\item{na.rm}{logical; if \code{TRUE}, then \code{NA}'s are removed from \code{x}. Default: \code{FALSE}.}
}
\value{
Numeric vector of the same length as \code{x} containing the integer (for \code{irank_against}) or fractional (for \code{frank_against}) ranks.
}
\description{
The method \code{\link{irank}} compares ranks using the same vector as reference.
\code{irank_against} returns integer ranks, that values from \code{x} would assume if (individually)
inserted into \code{v}. \code{frank_against} acts analogously, returning fractional ranks.
}
\details{
It's useful to think about \code{frank_against(x,v)} as a generalization of Empirical Cumulative
Distribution Function, created for \code{v} and evaluated for points in \code{x}.
\code{frank_agaist(x,v,increasing=TRUE,omega=1)} is identical
to \code{ecdf(v)(x)}.

\code{increasing} switches the inequality sign in ECDF definition from
\eqn{F_V(t) = \hat P(V <= t)} to \eqn{\hat P(V >= t)}.

\code{omega=0} introduces the strict inequality (\eqn{\hat P(V < t)} instead of \eqn{\hat P(V <= t)}).
Any \code{omega} in between is a weighted average of the cases \code{omega=1} and \code{omega=0}.

Finally, \code{irank_against} is equal to \code{frank_against} multiplied by the \code{length(v)}.

This particular choice of default parameters was made for compatibility with default parameters of
\code{irank} and \code{frank}. \code{irank(x)} is always equal to \code{irank_against(x,x)} and \code{frank(x)} is always equal to \code{frank_against(x,x)}.
}
\examples{
irank_against(1:10, c(4,4,4,3,1,10,7,7))
}
\seealso{
\code{\link[=irank]{irank()}}, \code{\link[=ecdf]{ecdf()}}
}
