% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csvwr.R
\name{datatype_to_type}
\alias{datatype_to_type}
\title{Map csvw datatypes to R types}
\usage{
datatype_to_type(datatypes)
}
\arguments{
\item{datatypes}{a list of csvw datatypes}
}
\value{
a \code{readr::cols} specification - a list of collectors
}
\description{
Translate \href{https://www.w3.org/TR/tabular-metadata/#datatypes}{csvw datatypes} to R types.
This implementation currently targets \link[readr:cols]{readr::cols} column specifications.
}
\examples{
\dontrun{
cspec <- datatype_to_type(list("double", list(base="date", format="yyyy-MM-dd")))
readr::read_csv(readr::readr_example("challenge.csv"), col_types=cspec)
}
}
