% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposure-APIs-batch.R
\name{get_aggregate_records_by_dtxsid_batch}
\alias{get_aggregate_records_by_dtxsid_batch}
\title{Get Aggregate Records by DTXSID via batch}
\usage{
get_aggregate_records_by_dtxsid_batch(
  DTXSID = NULL,
  API_key = NULL,
  rate_limit = 0L,
  Server = "https://comptox.epa.gov/ctx-api/exposure",
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{Chemical identifier DTXSID}

\item{API_key}{The user-specific API key}

\item{rate_limit}{Number of seconds to wait between each request}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logicial indicating if some "progress report" should be
given.}
}
\value{
A list of data.frames containing aggregate records data for each
input DTXSID.
}
\description{
Get Aggregate Records by DTXSID via batch
}
\examples{
\dontshow{if (FALSE) withAutoprint(\{ # examplesIf}
# Retrieve aggregate records data for BPA and Caffeine
get_aggregate_records_by_dtxsid_batch(DTXSID = c('DTXSID0020232',
  'DTXSID7020182'))
\dontshow{\}) # examplesIf}
}
