% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{cumulcalib}
\alias{cumulcalib}
\title{Cumulative calibration assessment}
\usage{
cumulcalib(y, p, method = c("BB", "BM"), ordered = FALSE, n_sim = 0)
}
\arguments{
\item{y}{vector of binary responses}

\item{p}{vector of predicted probabilities.}

\item{method}{string with either BB (Brownian bridge test, default method), BM (Brownian motion test), BM2p (two-part BM test - experimental), BB1p (one-part BB test wit only the 'bridge' component). Multiple methods can be specified. The first one will be the 'main' method (e.g., when submitting the resulting object to plot()). Default is c("BB","BM")}

\item{ordered}{if TRUE, y and p are already ordered based on ascending values of p. This is to speed up simulations.}

\item{n_sim}{if >0, indicates a simulation-based test is requested for inference.}
}
\value{
an objective of class cumulcalib that can be printed or plotted
}
\description{
This is the core function for performing cumulative calibration assessment
}
\examples{
pi <- rbeta(1000,1,2)
Y <- rbinom(length(pi),1,pi)
res <- cumulcalib(Y, pi, method="BB")
summary(res)
plot(res)
}
