% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{plot.cumulcalib}
\alias{plot.cumulcalib}
\title{Generates cumulative calibration plots}
\usage{
\method{plot}{cumulcalib}(
  x,
  method = NULL,
  draw_stat = TRUE,
  stat_col = c("blue", "red"),
  draw_sig = TRUE,
  sig_level = c(0.95, 0.95),
  x2axis = TRUE,
  y2axis = TRUE,
  ...
)

\method{plot}{cumulcalib}(
  x,
  method = NULL,
  draw_stat = TRUE,
  stat_col = c("blue", "red"),
  draw_sig = TRUE,
  sig_level = c(0.95, 0.95),
  x2axis = TRUE,
  y2axis = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class cumulcalib generated by cumulcalib()}

\item{method}{Which method to use. Options are BB (Brownian bridge test), BM (Brownian motion test), BB1p (1-part Brownian bridge test), and BM2p (2-part Brownian bridge test). If unspecified, returns the default method used in the cumulcalib() call}

\item{draw_stat}{Should the statistic (terminal value an/or maximum drift, depending on method) be drawn? Default is TRUE}

\item{stat_col}{The color(s) to draw the stat. Default is c('blue','red'). For single-part tests (BM and BB1p) only the first element is used}

\item{draw_sig}{Whether significance lines should be drawn. Default is T. Colors will be the same as stat_col}

\item{sig_level}{If to draw significance lines, at what level? Default is c(0.95,0.95). For single-part tests (BM and BB1p) only the first element is used}

\item{x2axis}{If true, draws a second x-axis (on top) showing predicted risks}

\item{y2axis}{If true, draws a second y-axis (on right) showing scaled partial sums}

\item{...}{Parameters to be passed to plot()}
}
\value{
None

None
}
\description{
Generates cumulative calibration plots
}
