% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIC.curesurv.R
\name{AIC.curesurv}
\alias{AIC.curesurv}
\title{Akaike's An Information Criterion for cure models}
\usage{
\method{AIC}{curesurv}(object, ..., k = 2)
}
\arguments{
\item{object}{a fitted model object obtained from \code{curesurv}}

\item{...}{optionally more fitted model objects obtained from \code{curesurv}.}

\item{k}{numeric, the penalty per parameter to be used; the default k = 2 is the classical AIC.}
}
\value{
the value corresponds to the AIC calculated from the log-likelihood of the fitted model if just one object is provided. If multiple objects are provided, a data.frame with columns corresponding to the objects and row representing the AIC
}
\description{
Calculates the Akaike's "An Information Criterion" for fitted models from \code{curesurv}
}
\details{
When comparing models fitted by maximum likelihood to the same data, the smaller the AIC, the better the fit.

However in our case, one should be careful when comparing the AIC. Specifically, when one implements a mixture cure model with \code{curesurv}
without correcting the rate table (\code{pophaz.alpha=FALSE}), one is not obligated to specify \code{cumpophaz}. However, you cannot compare a model where \code{cumpophaz}
is not specified with a model where \code{cumpophaz} is specified. If one wants to compare different models using AIC, one should always specify \code{cumpophaz} when
using the \code{curesurv} function.
}
\examples{
\donttest{

library("curesurv")
library("survival")

 testiscancer$age_crmin <- (testiscancer$age- min(testiscancer$age)) /
              sd(testiscancer$age)

fit_m1_ad_tneh <- curesurv(Surv(time_obs, event) ~ z_tau(age_crmin) +
                          z_alpha(age_crmin),
                          pophaz = "ehazard",
                          cumpophaz = "cumehazard",
                          model = "nmixture", dist = "tneh",
                          link_tau = "linear",
                          data = testiscancer,
                          method_opt = "L-BFGS-B")

 AIC(fit_m1_ad_tneh)

 }
}
