% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8-Draw.R
\name{fill_ellipse}
\alias{fill_ellipse}
\title{Draw a Filled-In Ellipse}
\usage{
fill_ellipse(yx = c(0, 0), rx = 1, ry = 1, n = 50, text = "x", ...)
}
\arguments{
\item{yx}{\code{(row, col)} coordinate of the center of the ellipse}

\item{rx}{radius along the x-axis in grid points}

\item{ry}{radius along the y-axis in grid points}

\item{n}{number of points along curve to calculate}

\item{text}{character value drawn at coordinate}

\item{...}{parameters that are passed to \code{style()}, including the foreground color \code{fg}, background color \code{bg}, and attribute \code{attr}}
}
\value{
\code{NULL}
}
\description{
Calculate the path of an ellipse within a grid and draw to screen.
}
\examples{
draw_ellipse(yx=c(10,10), rx=8, ry = 4)

}
\seealso{
Other drawing functions: 
\code{\link{box_at}()},
\code{\link{draw_arc}()},
\code{\link{draw_bezier}()},
\code{\link{draw_circle}()},
\code{\link{draw_ellipse}()},
\code{\link{draw_fn}()},
\code{\link{draw_lerp}()},
\code{\link{draw_path}()},
\code{\link{draw_ray}()},
\code{\link{draw_rect}()},
\code{\link{draw_shape}()},
\code{\link{fill_circle}()},
\code{\link{fill_rect}()},
\code{\link{fill_shape}()},
\code{\link{grid_at}()},
\code{\link{grid_mat}()},
\code{\link{hline_at}()},
\code{\link{hline}()},
\code{\link{vline_at}()},
\code{\link{vline}()}
}
\concept{drawing functions}
