% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{asymptotic_test2}
\alias{asymptotic_test2}
\title{Asymptotic test for the equality of coefficients of variation from k populations, using summary statistics when raw measurement data are not available.}
\usage{
asymptotic_test2(k, n, s, x, seed)
}
\arguments{
\item{k}{a numeric vector the number of groups}

\item{n}{a numeric vector the numer of measurements in each group}

\item{s}{a numeric vector the standard deviation of each group}

\item{x}{a numeric vector the mean of each group}

\item{seed}{optional, an integer that is the starting point used in the generation of a sequence of random numbers. Include a seed if you want reproducible output.}
}
\value{
a list with the test statistic and p-value
}
\description{
Test for k samples (k sample populations with unequal sized) from
Feltz CJ, Miller GE (1996) An asymptotic test for the equality of coefficients
of variation from k population. Stat Med 15:647–658
}
\examples{

# Summary stats from Feltz and Miller 1996

miller <- data.frame(test = c('ELISA', 'WEHI', '`Viral inhibition`'),
                    Mean = c(6.8, 8.5, 6.0),
                    CV =   c(0.090, 0.462, 0.340),
                    N =    c(5, 5, 5))
# compute SD from mean and cv
miller$SD <- with(miller, CV * Mean)

 asymptotic_test2(k = nrow(miller), n = miller$N, s = miller$SD, x = miller$Mean)

}
