% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvmaPLFAM.R
\name{cvmaPLFAM}
\alias{cvmaPLFAM}
\title{Cross-Validation Model Averaging (CVMA) for Partial Linear Functional Additive Models (PLFAMs)}
\usage{
cvmaPLFAM(
  Y,
  scalars,
  functional,
  Y.test = NULL,
  scalars.test = NULL,
  functional.test = NULL,
  tt,
  nump,
  numfpcs,
  nbasis,
  nfolds,
  ratio.train = NULL
)
}
\arguments{
\item{Y}{The vector of the scalar response variable.}

\item{scalars}{The design matrix of scalar predictors.}

\item{functional}{The matrix including records/measurements of the functional predictor.}

\item{Y.test}{Test data: The vector of the scalar response variable.}

\item{scalars.test}{Test data: The design matrix of scalar predictors.}

\item{functional.test}{Test data: The matrix including records/measurements of the functional predictor.}

\item{tt}{The vector of recording/measurement points for the functional predictor.}

\item{nump}{The number of scalar predictors in candidate models.}

\item{numfpcs}{The number of functional principal components (FPCs) for the functional predictor in candidate models.}

\item{nbasis}{The number of basis functions used for spline approximation.}

\item{nfolds}{The number of folds used in cross-validation.}

\item{ratio.train}{The ratio of data for training, if test data are \code{NULL}.}
}
\value{
A \code{list} of
    \item{cv}{Mean squared error risk in training data set, produced by CVMA method.}
    \item{wcv}{The weights for each candidate model by CVMA method.}
    \item{predcv}{Mean squared prediction error risk in test data set, produced by CVMA method.}
}
\description{
Summarize the estimate of weights for averaging across all candidate models for PLFAMs, using multi-fold cross-validation criterion,
     and the corresponding mean squared prediction error risk.
}
\examples{
# Generate simulated data
simdata = data_gen(R = 0.7, K = 1, n = 50, ntest = 10, M0 = 4, typ = 1, design = 1)
train_dat = simdata[[1]]
scalars.train = train_dat[,1:4]
fd.train = train_dat[,5:104]
Y.train = train_dat[,106]


test_dat = simdata[[2]]
scalars.test = test_dat[,1:4]
fd.test = test_dat[,5:104]
Y.test = test_dat[,106]

tps = seq(0, 1, length.out = 100)

# Estimation
res = cvmaPLFAM(Y=Y.train, scalars = scalars.train, functional = fd.train,
Y.test = Y.test, scalars.test = scalars.test, functional.test = fd.test, tt = tps,
       nump = 2, numfpcs = 3, nbasis = 50, nfolds = 5)
# Weights estimated by CVMA method
res$wcv
# Prediction error risk on test data set
res$predcv

}
