% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_metric_density.R
\name{plot_metric_density}
\alias{plot_metric_density}
\title{Density plot for a metric}
\usage{
plot_metric_density(
  results = NULL,
  baseline = NULL,
  metric = "",
  fill = c("darkblue", "lightblue"),
  alpha = 0.6,
  theme_fn = ggplot2::theme_minimal,
  xlim = NULL
)
}
\arguments{
\item{results}{\code{data.frame} with a metric column to create density plot for.

 To only plot the baseline, set to \code{NULL}.}

\item{baseline}{\code{data.frame} with the random evaluations from \code{\link[cvms:baseline]{baseline()}}.
 Should contain a column for the \code{metric}.

 To only plot the results, set to \code{NULL}.}

\item{metric}{Name of the metric column in \code{`results`} to plot. (Character)}

\item{fill}{Colors of the plotted distributions.
The first color is for the \code{`baseline`}, the second for the \code{`results`}.}

\item{alpha}{Transparency of the distribution (\code{0 - 1}).}

\item{theme_fn}{The \code{ggplot2} theme function to apply.}

\item{xlim}{Limits for the x-axis. Can be set to \code{NULL}.

 E.g. \code{c(0, 1)}.}
}
\value{
A \code{ggplot2} object with the density of a metric, possibly split
 in \emph{`Results`} and \emph{`Baseline`}.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

 Creates a \code{\link[ggplot2:ggplot]{ggplot2}} object with a density plot
 for one of the columns in the passed \code{data.frame}(s).

 Note: In its current form, it is mainly intended as a quick way to visualize
 the results from cross-validations and baselines (random evaluations).
 It may change significantly in future versions.
}
\examples{
\donttest{
# Attach packages
library(cvms)
library(dplyr)

# We will use the musicians and predicted.musicians datasets
musicians
predicted.musicians

# Set seed
set.seed(42)

# Create baseline for targets
bsl <- baseline_multinomial(
  test_data = musicians,
  dependent_col = "Class",
  n = 20 # Normally 100
)

# Evaluate predictions grouped by classifier and fold column
eval <- predicted.musicians \%>\%
  dplyr::group_by(Classifier, `Fold Column`) \%>\%
  evaluate(
    target_col = "Target",
    prediction_cols = c("A", "B", "C", "D"),
    type = "multinomial"
  )

# Plot density of the Overall Accuracy metric
plot_metric_density(
  results = eval,
  baseline = bsl$random_evaluations,
  metric = "Overall Accuracy",
  xlim = c(0, 1)
)

# The bulk of classifier results are much better than
# the baseline results
}
}
\seealso{
Other plotting functions: 
\code{\link{dynamic_font_color_settings}()},
\code{\link{font}()},
\code{\link{plot_confusion_matrix}()},
\code{\link{plot_probabilities}()},
\code{\link{plot_probabilities_ecdf}()},
\code{\link{sum_tile_settings}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{plotting functions}
