% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d3plus-package.R, R/d3plus.R
\docType{package}
\name{d3plus}
\alias{d3plus}
\alias{d3plus-package}
\alias{d3plus}
\title{An `htmlwidget` interface to the
d3plus javascript chart library}
\usage{
d3plus(data, width = NULL, height = NULL, elementId = NULL)
}
\arguments{
\item{data}{D3Plus need explicit specified data objects formatted as JSON, and this parameter passed it from R.}

\item{width}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{height}{Same as width parameter.}

\item{elementId}{Dummy string parameter. Useful when you have two or more charts on the same page.}
}
\description{
An `htmlwidget` interface to the
d3plus javascript chart library

This function provides 'D3Plus' methods from R console
}
\examples{
dta <- data.frame(
         id = c("alpha", "alpha", "alpha", "beta", "beta", "beta"),
         x = c(4,5,6,4,5,6),
         y = c(7,25,13,7,8,13)
       )

d3plus() \%>\% d3p_data(dta) \%>\% d3p_type("bar")
d3plus() \%>\% d3p_data(dta) \%>\% d3p_type("hbar")
d3plus() \%>\% d3p_data(dta) \%>\% d3p_type("area")

}
\author{
Mauricio Vargas
}
