% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{get_lower_upper}
\alias{get_lower_upper}
\alias{get_lower_upper.drift_dm}
\title{Get Default Parameter Ranges for a Model}
\usage{
get_lower_upper(object, ...)

\method{get_lower_upper}{drift_dm}(object, ..., warn = TRUE)
}
\arguments{
\item{object}{a \link{drift_dm} model.}

\item{...}{additional arguments passed forward to the respective method.}

\item{warn}{a single logical, if \code{TRUE} issue a warning listing components
and parameters where no defaults could be provided.}
}
\value{
a list with two named numeric vectors:
\itemize{
\item \code{lower} --- suggested lower bounds for free parameters
\item \code{upper} --- suggested upper bounds for free parameters
}
}
\description{
\code{get_lower_upper()} returns suggested default values for parameter
bounds of a \code{drift_dm} model. The function inspects the model's component
functions (e.g., drift, boundary, non-decision time, start) and provides
heuristic defaults for some of the pre-built components. Only parameters
that are currently considered \emph{free} in the model are returned.
}
\details{
Supported components include: \code{mu_constant}, \code{mu_dmc},
\code{mu_ssp}, \code{b_constant}, \code{x_uniform}, \code{x_beta}, \code{nt_constant},
\code{nt_uniform}, \code{nt_truncated_normal}. For some defaults we use the model's
discretization (\code{dt}, \code{dx}) to ensure sensible minima.

If a component is not recognized (or refers to currently unsupported
components), no defaults are provided for that component. When \code{warn = TRUE},
a single warning lists components without defaults and any free parameters
that remain unmatched. In this case, the user has to add the missing
parameter ranges before attempting to fit the model.

The default ranges are \strong{heuristics} intended to provide a reasonable
starting point for new users. They are not guaranteed to be
appropriate for every model or data set. Always review and, if needed,
adjust the returned values as needed.
}
\examples{
# get a model for the example
model <- dmc_dm(obs_data = dmc_synth_data)

# get the parameter ranges
lu <- get_lower_upper(model)
lu$lower
lu$upper

# then continue to estimate
# estimate_dm(model, lower = lu$lower, upper = lu$upper, optimizer = "nmkb")

}
