% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_mcmc_dm.R
\name{summary.mcmc_dm}
\alias{summary.mcmc_dm}
\alias{print.summary.mcmc_dm}
\title{Summary for \code{mcmc_dm} Objects}
\usage{
\method{summary}{mcmc_dm}(object, ..., id = NULL)

\method{print}{summary.mcmc_dm}(
  x,
  ...,
  round_digits = drift_dm_default_rounding(),
  show_statistics = TRUE,
  show_quantiles = FALSE,
  show_gr = TRUE,
  show_eff_n = TRUE
)
}
\arguments{
\item{object}{an object of class \code{mcmc_dm}, as returned by
\code{\link[=estimate_bayesian]{estimate_bayesian()}}}

\item{...}{additional arguments passed forward to
\code{\link[coda:summary.mcmc]{coda::summary.mcmc.list()}}.}

\item{id}{optional single numeric or character, specifying one or more
participant IDs to subset \code{object} in the hierarchical case. Note that \code{id}
will be converted to character, because dimension names of the chains stored
in \code{object} are character. If \code{NULL}, then the function is applied to
group-level parameters.}

\item{x}{an object of class \code{summary.mcmc_dm}, as returned by
\code{summary.mcmc_dm()}.}

\item{round_digits}{an integer, defining the number of digits for rounding
the output.}

\item{show_statistics}{a logical, if \code{TRUE}, print basic parameter
statistics (means, SDs, standard errors).}

\item{show_quantiles}{a logical, if \code{TRUE}, print quantile summary.}

\item{show_gr}{a logical; if \code{TRUE}, print Gelman-Rubin convergence
diagnostics for each parameter.}

\item{show_eff_n}{a logical, if \code{TRUE}, print effective sample sizes for
each parameter.}
}
\value{
\code{summary.mcmc_dm()} returns an object of class \code{summary.mcmc_dm},
which is a list with the following entries:
\itemize{
\item \code{general}: General information about the MCMC run.
\item \code{statistics}: Basic parameter summary statistics.
\item \code{quantiles}: Quantiles for each parameter.
\item \code{gr}: Gelman-Rubin diagnostics.
\item \code{eff_n}: Effective sample sizes.
}

\code{print.summary.mcmc_dm()} prints selected summary components and returns the
input object invisibly.
}
\description{
Summary and corresponding print methods for objects of the class \code{mcmc_dm},
resulting from a call to \code{\link[=estimate_bayesian]{estimate_bayesian()}}. \code{mcmc_dm}
objects contain MCMC samples for Bayesian parameter estimation of
\code{\link[=drift_dm]{drift_dm()}} objects. The summary includes basic parameter
statistics, quantiles, Gelman-Rubin diagnostics, and effective sample sizes.
}
\details{
The summary and diagnostic statistics of the MCMC chains are obtained
using the R package \code{coda}.
}
\examples{
mcmc_obj <- get_example_fits("mcmc_dm")
print(mcmc_obj)
summary(mcmc_obj)

}
\seealso{
\code{\link[coda:gelman.diag]{coda::gelman.diag()}}, \code{\link[coda:effectiveSize]{coda::effectiveSize()}},
\code{\link[coda:summary.mcmc]{coda::summary.mcmc.list()}}
}
