% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{cpTest}
\alias{cpTest}
\title{Multiple testing of change points for kernel smoothed data}
\usage{
cpTest(
  x,
  order,
  alpha,
  gamma,
  sigma,
  breaks,
  slope,
  untest,
  nu,
  is.constant,
  margin
)
}
\arguments{
\item{x}{vector of kernel smoothed data}

\item{order}{order of derivative of data}

\item{alpha}{global significant level}

\item{gamma}{bandwidth of Gaussian kernel}

\item{sigma}{standard deviation of kernel smoothed noise}

\item{breaks}{vector of rough estimate of change-point locations, only required when order is 1.}

\item{slope}{vector of rough estimate of slopes associated with \code{breaks}, only required when order is 1.}

\item{untest}{vector of locations unnecessary to test}

\item{nu}{standard deviation of Gaussian kernel used to generate autocorrelated Gaussian noise,
it is 0 if the noise is Gaussian white noise.}

\item{is.constant}{logical value indicating if the signal is piecewise constant,
if TRUE, \code{breaks} and \code{slope} are not necessary.}

\item{margin}{length of one period of data \code{x}}
}
\value{
a list of estimated change-point locations and threshold for p-value
}
\description{
Multiple testing of change points for kernel smoothed data
}
\examples{
## piecewise linear signal
l = 1200
h = seq(150,by=150,length.out=6)
jump = rep(0,7)
beta1 = c(2,-1,2.5,-3,-0.2,2.5)/50
beta1 = c(beta1,-sum(beta1*(c(h[1],diff(h))))/(l-tail(h,1)))
signal = gen.signal(l,h,jump,beta1)
noise = rnorm(length(signal),0,2)
gamma = 25
sdata = smth.gau(signal+noise,gamma)
ddy = diff(sdata,differences=2)
model2 = cpTest(x=ddy,order=2,gamma=gamma,alpha=0.05)
## piecewise constant
l = 1200
h = seq(150,by=150,length.out=6)
jump = c(0,1.5,2,2.2,1.8,2,1.5)
beta1 = rep(0,length(h)+1)
signal = gen.signal(l,h,jump,beta1)
noise = rnorm(length(signal),0,1)
gamma = 25
sdata = smth.gau(signal+noise,gamma)
dy = diff(sdata)
model1 = cpTest(x=dy,order=1,alpha=0.05,gamma=gamma,is.constant=TRUE)
## piecewise linear with jump
l = 1200
h = seq(150,by=150,length.out=6)
jump = c(0,1.5,2,2.2,1.8,2,1.5)*3
beta1 = c(2,-1,2.5,-3,-0.2,2.5,-0.5)/50
signal = gen.signal(l=l,h=h,jump=jump,b1=beta1)
noise = rnorm(length(signal),0,1)
gamma = 25
sdata = smth.gau(signal+noise,gamma)
dy = diff(sdata)
ddy = diff(sdata,differences=2)
model2 = cpTest(x=ddy,order=2,gamma=gamma,alpha=0.1)
breaks = est.pair(vall=model2$vall,peak=model2$peak,gamma=gamma)$cp
slope = est.slope(x=(signal+noise),breaks=breaks)
}
