% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skcla_svc.R
\name{skcla_svc}
\alias{skcla_svc}
\title{Support Vector Machine Classification}
\usage{
skcla_svc(
  attribute,
  slevels,
  kernel = "rbf",
  degree = 3,
  gamma = "scale",
  coef0 = 0,
  tol = 0.001,
  C = 1,
  shrinking = TRUE,
  probability = FALSE,
  cache_size = 200,
  class_weight = NULL,
  verbose = FALSE,
  max_iter = -1,
  decision_function_shape = "ovr",
  break_ties = FALSE,
  random_state = NULL
)
}
\arguments{
\item{attribute}{Target attribute name for model building}

\item{slevels}{List of possible values for classification target}

\item{kernel}{Kernel function type ('linear', 'poly', 'rbf', 'sigmoid')}

\item{degree}{Polynomial degree when using 'poly' kernel}

\item{gamma}{Kernel coefficient value}

\item{coef0}{Independent term value in kernel function}

\item{tol}{Tolerance value for stopping criterion}

\item{C}{Regularization strength parameter}

\item{shrinking}{Whether to use shrinking heuristic}

\item{probability}{Whether to enable probability estimates}

\item{cache_size}{Kernel cache size value in MB}

\item{class_weight}{Weights associated with classes}

\item{verbose}{Whether to enable verbose output}

\item{max_iter}{Maximum number of iterations}

\item{decision_function_shape}{Shape of decision function ('ovo', 'ovr')}

\item{break_ties}{Whether to break tie decisions}

\item{random_state}{Seed for random number generation}
}
\value{
A \code{skcla_svc} classifier object.
}
\description{
Implements classification using support vector machines.
Wraps scikit-learn's \code{SVC} through \code{reticulate}.
}
\details{
SVM Classifier
}
\examples{
\dontrun{
data(iris)

# 1) Create SVM classifier (RBF kernel)
clf <- skcla_svc(attribute = 'Species', slevels = levels(iris$Species), kernel = 'rbf', C = 1)

# 2) Fit and predict
clf <- daltoolbox::fit(clf, iris)
pred <- predict(clf, iris)
table(pred, iris$Species)
}

# More examples:
# https://github.com/cefet-rj-dal/daltoolboxdp/blob/main/examples/cla_svm.md
}
\references{
Cortes, C., & Vapnik, V. (1995). Support-Vector Networks.
}
