% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dann.R
\name{dann.data.frame}
\alias{dann.data.frame}
\title{Discriminant Adaptive Nearest Neighbor Classification}
\usage{
\method{dann}{data.frame}(
  x,
  y,
  k = 5,
  neighborhood_size = max(floor(nrow(x)/5), 50),
  epsilon = 1,
  ...
)
}
\arguments{
\item{x}{A data frame.}

\item{y}{A vector.}

\item{k}{The number of data points used for final classification.}

\item{neighborhood_size}{The number of data points used to calculate between and within class covariance.}

\item{epsilon}{Diagonal elements of a diagonal matrix. 1 is the identity matrix.}

\item{...}{Additional parameters passed to methods.}
}
\value{
An S3 class of type dann.
}
\description{
Discriminant Adaptive Nearest Neighbor Classification
}
\details{
This is an implementation of Hastie and Tibshirani's
\href{https://web.stanford.edu/~hastie/Papers/dann_IEEE.pdf}{Discriminant Adaptive Nearest Neighbor Classification publication.}.
}
\examples{
library(dann)
library(mlbench)
library(magrittr)
library(dplyr)

set.seed(1)
train <- mlbench.circle(300, 2) \%>\%
  tibble::as_tibble()
colnames(train) <- c("X1", "X2", "Y")
y <- train$Y
x <- train[, 1:2]

dann(x, y)
}
