% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.sexlinked.r
\name{gl.report.sexlinked}
\alias{gl.report.sexlinked}
\title{Filters loci that are sex linked}
\usage{
gl.report.sexlinked(
  x,
  system = NULL,
  ncores = 1,
  plot.display = TRUE,
  plot.theme = theme_dartR(),
  plot.colors = NULL,
  plot.file = NULL,
  plot.dir = NULL,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data. This genlight
object needs to contain the sex of the individuals. See explanation in 
details [required].}

\item{system}{String that declares the sex-determination system of the 
species: 'zw' or 'xy' [required].}

\item{ncores}{Number of processes to be used in parallel operation. If ncores
> 1 parallel operation is activated, see "Details" section [default 1].}

\item{plot.display}{Creates two output plots. See explanation in details
[default TRUE].}

\item{plot.theme}{Theme for the plot. See Details for options
[default theme_dartR()].[not yet implemented]}

\item{plot.colors}{[not implemented yet]}

\item{plot.file}{Name for the RDS binary file to save (base name only, 
exclude extension) [default NULL].}

\item{plot.dir}{Directory to save the plot RDS files [default as specified 
by the global working directory or tempdir()].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
 [default NULL, unless specified using gl.set.verbosity].}
}
\value{
A dataframe and 2 plots.
}
\description{
This function identifies sex-linked and autosomal loci present in a SNP 
dataset (genlight object) using individuals with known sex. It identifies
five types of loci: w-linked or y-linked, sex-biased, z-linked or
x-linked, gametologous and autosomal.

This function produces as output a dataframe and 2 plots.
}
\details{
The genlight object must contain in \code{gl@other$ind.metrics} a column 
named "id", and a column named "sex" in which individuals with known-sex are 
assigned 'M' for male, or 'F' for female. The function ignores individuals 
that are assigned anything else or nothing at all (unknown-sex).

The creation of plots can be turned-off (\code{plot.display = FALSE}) in order to save a 
little bit of running time for very large datasets (>50,000 SNPs). However, 
we strongly encourage you to always inspect the output plots at least once to
make sure everything is working properly.

\strong{ Function's output }

This function returns two plots:\itemize{
\item {A plot based on loci call rate by sex, with w/y-linked loci colored 
       in yellow and sex-biased loci in blue}
\item {A plot based on loci heterozygosity by sex, with z/x-linked loci colored 
       in orange and gametologs in green} 
}

And a dataframe in which loci are in rows, and columns:\itemize{
\item {index - Index number to identify loci}
\item {count.F.miss - Count of females that have this locus as missing data (NA).}
\item {count.M.miss - Count of males that have this locus as missing data (NA)}
\item {count.F.scored - Count of females that have this locus scored (0, 1 or 2; i.e. non-missing)}
\item {count.M.scored - Count of males that have this locus scored (0, 1 or 2; i.e. non-missing)}
\item {ratio - Fisher's exact test estimate testing for the independence of call rate and sex for this locus}
\item {p.value - P-value for the Fisher's exact test estimate}
\item {p.adjusted - P-value adjusted for false discovery rate}
\item {scoringRate.F - Female call rate (proportion of females that were scored for this locus; x-axis in the 1st plot)}
\item {scoringRate.M - Male call rate (proportion of males that were scored for this locus; y-axis in the 1st plot)}
\item {w.linked/y.linked - Boolean for this locus being w-linked/y-linked}
\item {sex.biased - Boolean for this locus having sex-biased call rate}
\item {count.F.het - Count of females that are heterozygous for this locus}
\item {count.M.het - Count of males that are heterozygous for this locus}
\item {count.F.hom - Count of females that are homozygous for this locus}
\item {count.M.hom - Count of males that are homozygous for this locus}
\item {stat - Fisher's exact test estimate testing for the independence of heterozygosity and sex for this locus}
\item {stat.p.value - P-value for the Fisher's exact test estimate}
\item {stat.p.adjusted - P-value adjusted for false discovery rate}
\item {heterozygosity.F - Proportion of females that are heterozygotes for this locus (x-axis in the 2nd plot)}
\item {heterozygosity.M - Proportion of males that are heterozygotes for this locus (y-axis in the 2nd plot)}
\item {z.linked/x.linked - Boolean for this locus being z-linked/x.linked}
\item {gametolog - Boolean for this locus being a gametolog}
}
}
\examples{
out <- gl.report.sexlinked(x = LBP, system = "xy", plot.display = TRUE, ncores = 1)

}
\references{
\itemize{
\item Robledo‐Ruiz, D. A., Austin, L., Amos, J. N., Castrejón‐Figueroa, J.,
 Harley, D. K., Magrath, M. J., Sunnucks, P., & Pavlova, A. (2023). 
 Easy‐to‐use R functions to separate reduced‐representation genomic datasets
  into sex‐linked and autosomal loci, and conduct sex assignment. Molecular 
  Ecology Resources, 00, 1-21.
 }
}
\author{
Custodian: Diana Robledo-Ruiz -- Post to
  \url{https://groups.google.com/d/forum/dartr}
}
