% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataMaid-package.R
\docType{data}
\name{toyData}
\alias{toyData}
\title{Small example data to show the features of dataMaid}
\format{
A \code{data.frame} with 15 rows and 6 variables.
\describe{
   \item{pill}{A factor variable with two levels (\code{"red"} and \code{"blue"}) and a few
   (correctly coded) missing observations. This represents the colour of a pill.}
   \item{events}{A numeric variable with one obvious outlier value (\code{82}), two miscoded
   missing values (\code{999} and \code{NaN}) and a few correctly coded missing values. The number of previous events.}
   \item{region}{A factor variable where two of the levels (\code{"other"} and \code{"OTHER"}
   are the same word with different case settings. Moreover, the variable includes a Stata-style
   miscoded missing value (\code{"."}). Used to represent geographical regions or treatment centers.}.
   \item{change}{A numeric variable (random draws from a standard normal distribution). Representing a change in a measured variable.}
   \item{id}{A factor variable with unique codes for each observation (a character string
   with a number between 1 and 15), i.e. a key variable.}
   \item{spotifysong}{A factor variable that has the same level (\code{"Irrelevant"}) for all
   observations, i.e. a empty variable. The latest song played on Spotify.}
}
}
\source{
Artificial data
}
\usage{
toyData
}
\description{
An artificial dataset, intended for presenting the key features of \code{dataMaid}, which is a
toolset for identifying potential errors in a dataset.
}
\examples{
data(toyData)

}
\references{
Petersen AH, Ekstrøm CT (2019). “dataMaid: Your Assistant for Documenting Supervised Data Quality Screening in R.” _Journal of Statistical Software_, *90*(6), 1-38. doi: 10.18637/jss.v090.i06 ( \doi{10.18637/jss.v090.i06}).
}
\keyword{datasets}
