% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_cal.R
\name{pivot_percent_at}
\alias{pivot_percent_at}
\title{Create an aggregated data table with all proportion of one selected column}
\usage{
pivot_percent_at(dt, question_col, aggregated_by_cols)
}
\arguments{
\item{dt}{data table}

\item{question_col}{column selected as questions}

\item{aggregated_by_cols}{grouped by columns}
}
\value{
aggregated data table
}
\description{
Create an aggregated data table with all proportion of one selected column
}
\examples{
test_dt <- data.table::data.table(
Question = c(rep("Good", 3), rep("OK", 3), rep("Bad", 3)),
Gender = c(rep("F", 4), rep("M", 5))
)
dataMojo::pivot_percent_at(test_dt,
  question_col = "Question", aggregated_by_cols = "Gender")
}
