% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{convert_pressure}
\alias{convert_pressure}
\title{Convert pressure data to hPa}
\usage{
convert_pressure(p, f = 1, lat = NA, alt = NA, atb = NULL)
}
\arguments{
\item{p}{A numerical vector of barometer observations in any unit of length.}

\item{f}{Conversion factor to mm (e.g., 25.4 for English inches).}

\item{lat}{Station latitude (degrees North in decimal).}

\item{alt}{Station altitude (metres). Assumed zero if not given. Ignored if
\code{lat} is NA.}

\item{atb}{A vector of the attached temperature observations in Celsius.}
}
\value{
A numerical vector of pressure values in hPa.
}
\description{
Converts pressure observations made with a mercury barometer to SI units.
If geographical coordinates are given, a gravity correction is applied.
If attached temperature is given, a temperature correction is applied.
}
\examples{
convert_pressure(760) # Gives a standard pressure of 1013.25 hPa

convert_pressure(760, lat=70, alt=100) # Gives a higher pressure because of higher g

convert_pressure(760, lat=70, alt=100, atb=20) # Gives a lower pressure because the
                                               # temperature correction is larger than 
                                               # the gravity correction.

}
\references{
WMO, 2008: Guide to meteorological instruments and methods of observation,
WMO-No. 8, World Meteorological Organization, Geneva.
}
\author{
Yuri Brugnara
}
